package main

import (
	"bufio"
	"crypto/tls"
	"fmt"
	"log"
	"net/http"
	"os"
	"strings"
	"time"

	"github.com/jackc/pgx"
)

func getCaldavProp(prop string, source string) string {
	var out string
	file, err := os.Open("/etc/yandex/calendar/" + source)
	if err != nil {
		fmt.Println(err)
	}

	defer file.Close()

	scanner := bufio.NewScanner(file)
	for scanner.Scan() {
		if strings.Contains(scanner.Text(), prop) {
			out = strings.Split(scanner.Text(), "=")[1]
		}
	}
	if out == "" {
		fmt.Println("No Pgpass probided")
	}
	return strings.Replace(out, " ", "", -1)
}

func MakePgConnection() *pgx.ConnPool {

	pgxConfig := pgx.ConnConfig{
		Host:                 "sas-ycqgnjhpmg3fnc6l.db.yandex.net", // host (e.g. localhost) or path to unix domain socket directory (e.g. /private/tmp)
		Port:                 6432,
		Database:             "calendardb",
		User:                 "calendartmp",
		Password:             getCaldavProp("public.calendar.jdbc.password", "secrets.properties"), // default: OS user name
		TLSConfig:            &tls.Config{InsecureSkipVerify: true},                                // config for TLS connection -- nil disables TLS
		PreferSimpleProtocol: true,
	}

	pgxConnPoolConfig := pgx.ConnPoolConfig{
		ConnConfig:     pgxConfig,
		MaxConnections: 11,
		AcquireTimeout: 30 * time.Second,
	}

	conn, err := pgx.NewConnPool(pgxConnPoolConfig)
	if err != nil {
		fmt.Println("error in pool creationg")
		log.Fatal(err)
	}

	return conn
}

func RunServer(address string) {
	http.HandleFunc("/blackbox", func(w http.ResponseWriter, r *http.Request) {
		switch r.FormValue("method") {
		case "userinfo":
			UserinfoHandler(w, r)
		case "login":
			LoginHandler(w, r)
		default:
			w.WriteHeader(404)
			_, err := w.Write([]byte(""))
			if err != nil {
				log.Println(err)
			}
		}
	})
	log.Fatalln(http.ListenAndServe(address, nil))
}
