package main

//импорт нужных элементов pandora. Они позволяют управлять нагрузкой, делать замеры и отдавать результаты в танк
import (
	"fmt"
	"io/ioutil"
	"log"
	"math/rand"
	"net/http"
	"strconv"
	"strings"
	"time"

	"github.com/yandex/pandora/cli"
	"github.com/yandex/pandora/core"
	"github.com/yandex/pandora/core/aggregator/netsample"
	coreimport "github.com/yandex/pandora/core/import"
	"github.com/yandex/pandora/core/register"
)

type Ammo struct {
	Tag    string
	Param1 string
}

type GunConfig struct {
	Target string `validate:"required"`
	Global int
}

type Pair struct {
	From string `validate:"required"`
	To   string `validate:"required"`
}

type Gun struct {
	client http.Client
	conf   GunConfig
	aggr   core.Aggregator
	core.GunDeps
}

func ExampleGun(conf GunConfig) *Gun {
	return &Gun{conf: conf}
}

func (g *Gun) Bind(aggr core.Aggregator, deps core.GunDeps) error {
	tr := &http.Transport{
		MaxIdleConns:       1,
		IdleConnTimeout:    time.Duration(g.conf.Global) * time.Second,
		DisableCompression: true,
	}
	g.client = http.Client{Transport: tr}
	g.aggr = aggr
	g.GunDeps = deps
	return nil
}

func (g *Gun) Shoot(ammo core.Ammo) {
	customAmmo := ammo.(*Ammo)
	g.shoot(customAmmo)
}

func (g *Gun) shoot(ammo *Ammo) {
	code := 0 //выставляем код ответа по умолчанию
	//формируем запрос, парметризуем его и добавляем параметризованные хедеры
	uid := strconv.FormatInt(rand.Int63n(10000000), 10)
	fmt.Println("Working with uid: " + uid)

	tag := "/internal/create-event"
	replacer := strings.NewReplacer("\t", " ")
	buf := replacer.Replace(`{
              "type": "user",
              "startTs": "2019-09-03T13:00:00+03:00",
              "endTs": "2019-09-03T14:00:00+03:00",
              "name":"И снова 3 сентября",
              "location":"Место",
              "description":"Описание",
              "isAllDay":false,
              "availability": "available",
              "notifications": [
                 {"channel":"email","offset":"-10m"}
               ],
              "attendees": [],
              "repetition": {
                 "type": "yearly",
                 "each":1
              },
              "participantsCanInvite":false,
              "participantsCanEdit":false,
              "othersCanView":true
         }`)
	req, _ := http.NewRequest("POST", strings.Join([]string{g.conf.Target, tag, "?uid=", uid}, ""), strings.NewReader(buf))
	req.Header.Add("Connection", "keep-alive")
	req.Header.Add("User-Agent", ammo.Param1)
	req.Header.Add("Content-Type", "application/json")

	sample := netsample.Acquire(tag) // стартуем замер. Это нужно, чтобы в отчёте можно было увидеть, сколько времени выполнялось действие.
	rs, err := g.client.Do(req)      // делаем сам запрос
	if err == nil {
		//oбрабатываем результат. "Принты" уйдут в лог пандоры, если нужно дебажить ответы, можно их после стрельбы обработать
		code = rs.StatusCode
		respBody, _ := ioutil.ReadAll(rs.Body)
		err = rs.Body.Close()
		if err != nil {
			log.Println(err)
		}
		fmt.Println(string(respBody))
	} else {
		fmt.Println(err)
	}
	//после всего закрываем замер и отправляем результат замера танку для дальнейшей агрегации
	//можно делать вложенные замеры, или несколько в одном shoot(). В этом случае rps на графиках будет отличаться от заданного расписания
	sample.SetProtoCode(code)
	g.aggr.Report(sample)

	actionsRange := []string{"/get-events?from=%s&to=%s&lang=ru&limitAttendees=true",
		"/get-todo-items?only-not-completed=true&due-from=%s&due-to=%s&locale=ru&output=json"}
	dates := []Pair{Pair{"2019-08-26", "2019-09-01"}, Pair{"2019-09-02", "2019-09-08"}, Pair{"2019-09-09", "2019-09-15"}}
	for _, action := range actionsRange {
		for _, date := range dates {
			tag := fmt.Sprintf(action, date.From, date.To)
			fmt.Println("Tag to handle " + tag)
			url := tag + "&uid=" + uid
			req, _ := http.NewRequest("GET", strings.Join([]string{g.conf.Target, url}, ""), nil)
			req.Header.Add("Connection", "keep-alive")
			req.Header.Add("User-Agent", ammo.Param1)
			req.Header.Add("Content-Type", "application/json")

			code := 0

			sample := netsample.Acquire(tag)
			rs, err := g.client.Do(req)

			if err == nil {
				//oбрабатываем результат. "Принты" уйдут в лог пандоры, если нужно дебажить ответы, можно их после стрельбы обработать
				code = rs.StatusCode
				respBody, _ := ioutil.ReadAll(rs.Body)
				err = rs.Body.Close()
				if err != nil {
					log.Println(err)
				}
				fmt.Println(string(respBody))
			} else {
				fmt.Println(err)
			}

			sample.SetProtoCode(code)
			g.aggr.Report(sample)
		}
	}

	body := replacer.Replace(`{
		"emails": [],
		"start": "2019-09-03T13:00:00+03:00",
        "end": "2019-09-03T14:00:00+03:00",
		"repetition": {
			"type": "yearly",
			"each":1
		 }
	}`)

	actionsUids := []string{"/get-user-layers?lang=ru&", "/get-availabilities?tz=Europe%2FMoscow&",
		"/get-holidays?from=2019-01-01&to=2020-02-29&for=9999%2C213%2C1%2C3%2C225%2C10001%2C10000&outMode=overrides&",
		"/get-timezones?", "/get-events?from=2019-09-02&to=2019-09-08&lang=ru&limitAttendees=true&"}

	for _, action := range actionsUids {
		tag := action
		fmt.Println("Tag to handle " + tag)
		url := tag + "uid=" + uid
		req, _ := http.NewRequest("POST", strings.Join([]string{g.conf.Target, url}, ""), strings.NewReader(body))
		req.Header.Add("Connection", "keep-alive")
		req.Header.Add("User-Agent", ammo.Param1)
		req.Header.Add("Content-Type", "application/json")

		code := 0

		sample := netsample.Acquire(tag)
		rs, err := g.client.Do(req)

		if err == nil {
			//oбрабатываем результат. "Принты" уйдут в лог пандоры, если нужно дебажить ответы, можно их после стрельбы обработать
			code = rs.StatusCode
			respBody, _ := ioutil.ReadAll(rs.Body)
			err = rs.Body.Close()
			if err != nil {
				log.Println(err)
			}
			fmt.Println(string(respBody))
		} else {
			fmt.Println(err)
		}

		sample.SetProtoCode(code)
		g.aggr.Report(sample)
	}
}

func main() {
	rand.Seed(time.Now().UTC().UnixNano())
	fs := coreimport.GetFs()
	coreimport.Import(fs)
	//регистрируем провайдера патронов и даём ему название
	coreimport.RegisterCustomJSONProvider("example_provider", func() core.Ammo { return &Ammo{} })
	//регистрируем Gun
	register.Gun("example", ExampleGun, func() GunConfig {
		return GunConfig{
			Target: "default target",
		}
	})
	cli.Run()
}
