package ru.yandex.calendar.micro;

import io.micronaut.context.ApplicationContext;

import java.io.Closeable;

public class MicroCoreContext implements Closeable {
    private final ApplicationContext context;

    public MicroCoreContext(String... environments) {
        this.context = ApplicationContext.build(environments)
            .deduceEnvironment(false)
            .start();

        context.getBeansOfType(Initializable.class)
            .forEach(Initializable::initialize);
    }

    public <T> T findBean(Class<T> beanType) {
        return context.getBean(beanType);
    }

    @Override
    public void close() {
        context.close();
    }
}
