package ru.yandex.calendar.micro.l10n;

import lombok.AllArgsConstructor;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;

import java.util.Map;
import java.util.Optional;

@AllArgsConstructor
public class LocalizedString {
    private final Map<Language, String> values;

    public Optional<String> get(Language language) {
        return Optional.ofNullable(values.get(language));
    }

    public String getOrDefault(Language language, String defaultValue) {
        return values.getOrDefault(language, defaultValue);
    }

    public StreamEx<String> getAllValues() {
        return EntryStream.of(values)
            .values();
    }
}
