package ru.yandex.calendar.micro.so;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Min;
import javax.validation.constraints.Max;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Introspected;
import lombok.AllArgsConstructor;
import lombok.Value;

@Value
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@Introspected
@AllArgsConstructor(onConstructor_= @JsonCreator)
public class Form {
    @Value
    @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
    @AllArgsConstructor(onConstructor_= {@JsonCreator, @Creator})
    @Introspected
    public static class FormField {
        @NotBlank String type;
        @NotNull Object value;
        @NotBlank String filledBy;

        FormField(String value) {
            this(value, "user");
        }

        FormField(List<String> value) {
            this("List", value, "user");
        }

        FormField(String value, String filledBy) {
            this("String", value, filledBy);
        }
    }

    @Value
    @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
    @Introspected
    public static class FormFields {
        @NotNull @Valid FormField location;
        @NotNull @Valid FormField description;
        @NotNull @Valid FormField id;
        @NotNull @Valid FormField summary;
        @NotNull @Valid FormField timeStart;
        @NotNull @Valid FormField timeEnd;
        @NotNull @Valid FormField participants;

        @JsonCreator
        public FormFields(String location, String description, String summary, String id,
                          String timeStart, String timeEnd, List<String> participants) {
            this.location = new FormField(location);
            this.description = new FormField(description);
            this.summary = new FormField(summary);
            this.id = new FormField(id, "automatic");
            this.timeStart = new FormField(timeStart);
            this.timeEnd = new FormField(timeEnd);
            this.participants = new FormField(participants);
        }
    }

    @NotEmpty String environment;
    @NotEmpty String formType;
    @NotNull String action;
    @NotNull String clientIp;
    @NotNull String subject;
    @Min(1) @Max(Long.MAX_VALUE) long formAuthor; //TODO replace by @Positive when we will have micronaut 1.2.6.
    @NotNull String formRealpath;
    @NotNull @Valid FormFields formFields;
}
