package ru.yandex.calendar.micro.so;

import java.util.concurrent.CompletableFuture;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.validation.Validated;

@Validated
@Client(id = "so", errorType = String.class)
public interface SoCheckClient {
    @Post("/check-json")
    CompletableFuture<String> sendForm(@QueryValue @NotEmpty String service,
                                       @QueryValue @NotEmpty String id,
                                       @QueryValue("form_id") String formId,
                                       @Body @Valid Form form);


    default CompletableFuture<Boolean> checkForm(String service, String id, String formId, Form form) {
        return sendForm(service, id, formId, form).thenApply(SoCheckClient::parseResponse);
    }

    private static boolean parseResponse(String content) {
        if (content.contains("<spam>0</spam>")) {
            return false;
        } else if (content.contains("<spam>1</spam>")) {
            return true;
        } else {
            throw new SoInvalidResponseException("Answer from SO was incorrect, expected in tag spam 1 or 0 but answer was = " + content);
        }
    }
}
