package ru.yandex.calendar.micro.yt;

import io.micronaut.scheduling.TaskExecutors;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

import javax.inject.Named;
import javax.inject.Singleton;
import java.time.Duration;
import java.util.concurrent.ExecutorService;

@Singleton
public class Throttle {
    private final Scheduler scheduler;

    public Throttle(@Named(TaskExecutors.SCHEDULED) ExecutorService scheduledExecutor) {
        this.scheduler = Schedulers.fromExecutor(scheduledExecutor);
    }

    public <T> Flux<T> apply(Flux<T> flux, Duration delay) {
        return delay.isZero() ? flux : flux.delayElements(delay, scheduler);
    }
}
