package ru.yandex.calendar.micro.yt;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.experimental.FieldDefaults;
import reactor.core.publisher.Flux;

import java.time.Duration;
import java.util.List;

import static ru.yandex.mail.micronaut.common.CerberusUtils.mapToList;

@AllArgsConstructor(access = AccessLevel.PACKAGE)
@FieldDefaults(makeFinal = true, level = AccessLevel.PRIVATE)
final class YtCerberusFetcher<In, Out> {
    @FunctionalInterface
    interface Fetcher<In> {
        Flux<List<In>> fetch(int pageSize);
    }

    @FunctionalInterface
    interface Mapper<In, Out> {
        Out map(In value);
    }

    Throttle throttle;
    int pageSize;
    Mapper<In, Out> mapper;
    Fetcher<In> fetcher;

    private List<Out> map(List<In> list) {
        return mapToList(list, mapper::map);
    }

    private Flux<List<In>> fetchWithThrottle(Duration delay) {
        return throttle.apply(fetcher.fetch(pageSize), delay);
    }

    public Flux<List<Out>> fetchAllBatches(Duration delay) {
        return fetchWithThrottle(delay)
            .map(chunk -> mapToList(chunk, mapper::map));
    }

    public Flux<Out> fetchAll(Duration delay) {
        return fetchWithThrottle(delay)
            .flatMapIterable(this::map, pageSize);
    }
}
