package ru.yandex.calendar.micro.yt.entity;

import lombok.Value;
import ru.yandex.calendar.micro.l10n.Language;
import ru.yandex.calendar.micro.l10n.LocalizedString;
import ru.yandex.mail.cerberus.GroupId;
import ru.yandex.mail.cerberus.yt.data.YtDepartmentInfo;

import java.util.Map;

@Value
public class YtDepartment {
    GroupId id;
    String name;
    boolean active;
    YtDepartmentInfo info;

    public LocalizedString extractFullNameL10n() {
        return new LocalizedString(Map.of(
            Language.RUSSIAN, info.getFullNameRu(),
            Language.ENGLISH, info.getFullNameEn()
        ));
    }
}
