package ru.yandex.calendar.micro.yt.entity;

import lombok.Value;
import ru.yandex.calendar.micro.l10n.Language;
import ru.yandex.calendar.micro.l10n.LocalizedString;
import ru.yandex.mail.cerberus.Uid;
import ru.yandex.mail.cerberus.yt.data.YtUserInfo;

import java.util.Map;

@Value
public class YtUser {
    Uid uid;
    String login;
    YtUserInfo info;

    public LocalizedString extractFirstNameL10n() {
        return new LocalizedString(Map.of(
            Language.RUSSIAN, info.getFirstNameRu(),
            Language.ENGLISH, info.getFirstNameEn()
        ));
    }

    public LocalizedString extractLastNameL10n() {
        return new LocalizedString(Map.of(
            Language.RUSSIAN, info.getLastNameRu(),
            Language.ENGLISH, info.getLastNameEn()
        ));
    }
}
