function Set (list)
    local set = {}
    for _, l in ipairs(list) do set[l] = true end
    return set
end

white_project_ids = Set{
    "0:640",     --MAILNETS
    "0:41e2",    --MAILTESTNETS
    "0:463e",    --CALENDAR_TEST_NETS
    "0:4601",    --CALENDAR_PROD_NETS
    "0:41f8",    --UHURA_PROD_NETS       (15.04 UHURA-868)
    "0:423c",    --EASYMEETING_PROD_NETS (15.04 EASYMEET-183)
    "10c:f118"   --GENCFG_WORKPLACE      (WORKPLACE-327)
};
white_ips = Set{
    "2a02:6b8:0:142f:225:90ff:fec1:d280",      --simcity03.search.yandex.net (requests once a week MSERVDUTY-193)
    "2a02:6b8:b000:b128:feaa:14ff:fe65:ce2e" --LOGFELLERNETS (LOGBROKER-5991)
};
grey_project_ids = Set{
    "0:4100",    --SEARCHHITMANNETS
    "0:40f3",    --ISEARCH_PROD_NETS
    "0:604",     --SEARCHPRODNETS
    "0:696",     --SEARCHSAND
    "0:1462",    --CONTESTVIRTNETS
    "0:676",     --BALANCESANDBOX
    "0:522",     --CMSEARCHNETS
    "0:627",     --BALANCE (30-31.03 - no requests)
    "0:40d5",    --CAB_PROD_NETS
    "0:510",     --DISTBUILDNETS
    "0:47ef",    --SEARCHMON_YAINCBOT_NETS
    "8000:4098", --VERTISPRODNETS
    "0:4828",    --UCHENKI_NETS
    "0:1354",    --SEARCHPRODNETS (IMGDEVOPS-1297, USEREXP-8948, SWAT-6624)
    "0:575",     --HAASNETS (30-31.03 - no requests)
    "0:4457",    --NIRVANA_REGULAR_JOB_NETS
    "0:44f7",    --TAXI_TELEGRAM_BOTS_DEVELOPERS_PROD_NETS
    "0:4317",    --BROWSER_DEV_NETS
    "0:41a7",    --B2BGEO_YA_COURIER_PROD_NETS
    "0:4111",    --RASP_PROD_NETS
    "10d:c384",  --GENCFG_MARKET_TEST
    "0:41e3"     --MAPSPRODQNETS (30-31.03 - no requests)
};
grey_ips = Set{
    "2a02:6b8:b010:5039::c001",               --sdc01.telegraph.yndx.net
    "2a02:6b8:b010:5039::a001",               --ast01.telegraph.yndx.net
    "2a02:6b8:b010:900e::a001",               --ast02.telegraph.yndx.net
    "2a02:6b8:b000:109:225:90ff:fe83:2e24",   --IMGDEVOPS-1297
    "2a02:6b8:b000:6073:e61d:2dff:fe6e:3b60", --IMGDEVOPS-1297
    "2a02:6b8:b010:ad::142",                  --infra-tools-sas-01.taxi.yandex.net
    "2a02:6b8:b010:5084::160",                --infra-tools-iva-01.taxi.yandex.net
    "2a02:6b8:b010:702b::118",                --infra-tools-myt-01.taxi.yandex.net
    "2a02:6b8:b010:5026:98c6:ef48:e173:e943", --alpha.market.yandex.net
    "2a02:6b8:b000:a037:92e2:baff:fea3:73e8", --watchman.search.yandex.net (30-31.03 - no requests)
    "2a02:6b8:b000:14f:225:90ff:fe83:802",    --USEREXP-8948
    "2a02:6b8:b000:643:96de:80ff:fe81:136e",  --USEREXP-8948
    "2a02:6b8:b000:b128:feaa:14ff:fe65:ce2e", --hors-man-01.search.yandex.net
    "2a02:6b8:b000:600e:92e2:baff:fe5b:9c2c", --USEREXP-8948
    "2a02:6b8:b000:603a:92e2:baff:fe74:7f46", --USEREXP-8948
    "2a02:6b8:b000:6034:92e2:baff:fe52:7898", --USEREXP-8948
    "2a02:6b8:b040:5102:215:b2ff:fea9:67e2"  --build01-myt.yt.yandex.net (30-31.03 - no requests)
};

function project_id_from_ip(ip)
    return string.match(ip, ":([^:]*:[^:]*):[^:]*:[^:]*$"); --we need 3rd and 4th block from the end
end

function is_in_the_lists(ip, project_ids, ips)
    if string.sub(ip, 1, 10) == "2a02:6b8:c" then
        project_id = project_id_from_ip(ip)
        if project_id and project_ids[project_id] then
            return true;
        end
    end
    if ips[ip] then
        return true;
    end
    return false;
end

function is_white(ip)
    return is_in_the_lists(ip, white_project_ids, white_ips);
end

function is_grey(ip)
    return is_in_the_lists(ip, grey_project_ids, grey_ips);
end

function reject_request()
    ngx.log(ngx.ERR, "The request was rejected.");
    ngx.status = ngx.HTTP_UNAUTHORIZED;
    ngx.say("In case of emergency, add a ticket to the MSERVDUTY queue.");
    ngx.exit(ngx.HTTP_OK)
end

function check_ip(ip)
    if is_white(ip) then
        ngx.var.tvm_check_status = "WHITELISTED";
        return;
    end
    if is_grey(ip) then
        ngx.var.tvm_check_status = "GREYLISTED";
        reject_request();
        return;
    end
    ngx.var.tvm_check_status = "NOT_IN_THE_LISTS";
    reject_request();
end

if not ngx.req.get_headers()['X-Ya-Service-Ticket'] then
    check_ip(ngx.var.remote_addr);
else
    ngx.var.tvm_check_status = "WITH_TVM";
end
