#!/bin/bash

if [ -z $ENVIRONMENT_TYPE ];then
    ENVIRONMENT_TYPE=$QLOUD_ENVIRONMENT
fi

if [ -z $APPLICATION_NAME ];then
    APPLICATION_NAME=$QLOUD_COMPONENT
fi

if [ -z $CALENDAR_DOMAIN ];then
    CALENDAR_DOMAIN=$QLOUD_APPLICATION
fi

if [ -z $ACTIVE_PROCESSOR_COUNT ];then
    export ACTIVE_PROCESSOR_COUNT=${QLOUD_CPU_LIMIT/.*}
fi

if [ "$ENVIRONMENT_TYPE" == "load" ]; then
    echo "stress" > /etc/yandex/environment.type
    echo "" > /etc/nginx/tvm_access.lua
else
    echo $ENVIRONMENT_TYPE > /etc/yandex/environment.type
fi

mkdir -p /var/lib/yandex/calendar/

. /usr/lib/qloud-mail-common.sh
check_ephemeral && (
  qloud_link /var/log/calendar
  qloud_link /var/log/nginx
  qloud_link /var/heapdumps
  qloud_link /var/spool/calendar
  qloud_link /var/lib/yandex/calendar/staff-cache
)

mkdir -p /var/heapdumps/
mkdir -p /var/log/calendar/
mkdir -p /etc/nginx/sites-enabled/

# Это нужно, чтобы срабатывала ротация каждый час - это наиболее безопасный способ, см. детали здесь https://unix.stackexchange.com/a/366468
chmod 755 /etc/cron.daily/logrotate && dpkg-divert --add --rename --divert /etc/cron.hourly/logrotate /etc/cron.daily/logrotate
chmod 644 /etc/cron.d/nginx_upstream_gen

ln -svf /etc/supervisor/$CALENDAR_DOMAIN/$ENVIRONMENT_TYPE/$APPLICATION_NAME.conf /etc/supervisor/conf.d/
ln -svf /etc/yandex/calendar-common.properties                                    /etc/yandex/calendar/calendar-common.properties
cat /etc/yandex/calendar-$ENVIRONMENT_TYPE.properties > /etc/yandex/calendar/calendar.properties
ln -svf /etc/nginx/sites-available/unistat.conf                                   /etc/nginx/sites-enabled/
ln -svf /etc/nginx/sites-available/$APPLICATION_NAME.conf                         /etc/nginx/sites-enabled/

ln -svf /etc/supervisor/conf-available/push-client.conf                           /etc/supervisor/conf.d/
ln -svf /etc/push-client/conf-available/$CALENDAR_DOMAIN/$APPLICATION_NAME.yaml   /etc/push-client/

MONRUN_CONF_PATH="/etc/monrun/conf-available/${CALENDAR_DOMAIN}/${APPLICATION_NAME}.conf"
if [ -f "${MONRUN_CONF_PATH}" ] ; then
    ln -svf "${MONRUN_CONF_PATH}" /etc/monrun/conf.d/
fi

# Allow monitor tasks to read secret properties
usermod -aG root monitor
chmod 755 /etc/yandex/calendar
chmod 640 /etc/yandex/calendar/secrets.properties

# Allow juggler-client to use QLOUD_TVM_TOKEN
echo $QLOUD_TVM_TOKEN > /etc/yandex/calendar/tvmtool.token
chmod 640 /etc/yandex/calendar/tvmtool.token

# If admin certificate exist - link admin config:
if [ -f /etc/nginx/ssl/calendar-admin.pem ]; then
    ln -svf /etc/nginx/sites-available/admin.conf /etc/nginx/sites-enabled
fi

# If caldav certificate exists, link it and listen to ssl ports
if [ -f /etc/nginx/ssl/calendar-caldav.pem ]; then
    ln -svf /etc/nginx/includes/caldav_ssl /etc/nginx/includes/caldav_ssl.safe
fi

# If web certificate exists, link it and listen to ssl ports
if [ -f /etc/nginx/ssl/calendar-web.pem ]; then
    ln -svf /etc/nginx/includes/web_ssl /etc/nginx/includes/web_ssl.safe
fi

# Add custom properties, if there are any
if [ -f /etc/yandex/$CALENDAR_DOMAIN/$ENVIRONMENT_TYPE/$APPLICATION_NAME.properties ]; then
    echo "" >> /etc/yandex/calendar/calendar.properties
    cat /etc/yandex/$CALENDAR_DOMAIN/$ENVIRONMENT_TYPE/$APPLICATION_NAME.properties >> /etc/yandex/calendar/calendar.properties
fi

# Add pad settings - but only if required - that's the prestable environment
if [ -f /etc/nginx/ssl/pad.pem ] && [ "$QLOUD_ENVIRONMENT" == "prestable" ] && [ "$QLOUD_COMPONENT" == "web-prestable" ] && [ "$QLOUD_APPLICATION" == "calendar-yt" ]; then
    ln -svf /etc/nginx/sites-available/pad.conf /etc/nginx/sites-enabled
fi

# just to avoid library version tracking
for f in /usr/lib/yandex/calendar/lib/ea-async-*.jar; do
  ln -svf "$f" /usr/lib/yandex/calendar/lib/ea-async.jar
done

exec "$@"

