# Описание образа

## Логирование

Когда мы только начинали делать этот образ, логи писались раз в день. Однако с этим был
ряд проблем:

* В день пишется до 30 Гигабайт логов, это огромные два файла веба, что не очень приемлемо.
* Ротация логов может приводить к серьезным проблемам приложения.

Как говорится, с этого места поподробнее. Все дело в том, как устроены наши логгеры и как 
работает запись на диск. Логгеры у нас по идее асинхронные... но это только на первый
взгляд. Все дело в том, что эта асинхронность всего лишь навсего подразумевает, что есть два потока в логгере.
Один пишет в очередь сообщения (у очереди фиксированный размер, изначально был 4К, я увеличил до 32К).
Второй поток берет из этой очереди и пишет в файл - точнее, в грязные страницы. Раз в полминуты
приходит pdflush и начинает сбрасывать эти страницы реально в файловую систему.

При этом, если pdflush пишет чересчур долго, то получается следующее - второй поток не может записать
на диск, и очередь заполняется по полной. Когда она заполнилась, первый поток будет **блокировать** ВСЕ
потоки приложения, которые вызывают логгер. В этот момент приложение начинает отдавать 502 по полной
(точнее, nginx, не получая ни ответа, ни привета, начинает такое возвращать). 

Как показал анализ, ротация логов раз в сутки будет длиться минут 20, т.е. все это время приложение будет 
периодически по страшной силе тупить, поскольку ротатор еще и сжимает данные и пишет их на диск.

Что же делать?

* Перейти с log4j первой версию на вторую - в ней производительность получше.
* Когда приходит сообщение, и мы не можем записать его в очередь, просто игнорируем его.

На оба варианта пока что еще руки не дошли сделать. Поэтому сделали вот что - часовую ротацию с рандомизацией.
Если посмотреть в /deploy/etc/cron.daily/logrotate, то там можно увидеть следующие
прекрасные строки

```bash
sleep_delay=$((RANDOM % 600))
sleep $sleep_delay
```

Это приводит к тому, что ротатор перед запуском ротации спит в диапазоне от 0 до 10 минут. У нас 
шесть инстансов веба, к примеру,  и если каждый из них укладывается в минуту (а они укладываются
при часовой ротации), то этого будет достаточно для того, чтобы большая часть инстансов прекрасно все
отдавала балансеру.

Самое интересное, как понять, что ротация логов работает. Для начала стоит посмотреть в /etc/crontab и увидеть
там следующие строки:

```properties
17 *    * * *   root    cd / && run-parts --report /etc/cron.hourly
```

Это намек, что каждый час в 17 минут запускается помимо прочего наша ротация. Если в это время выполнить
следующую команду:

```bash
ps aux | grep logrotate
# root       73093  0.0  0.0   9536  2656 ?        S    20:17   0:00 /bin/sh /etc/cron.hourly/logrotate
# root       74067  0.0  0.0  25624  2288 ?        S    20:19   0:00 /usr/sbin/logrotate /etc/logrotate.conf
```

Если ты видишь только первую строку вывода, то это значит, что ротация еще спит. Если вторую, значит пошел процесс.
Также можно посмотреть время последней отработки ротации (т.е. когда она вышла из сна и перешла в активную фазу),
выполнив следующую команду:

```bash
ls -lh /var/lib/logrotate/status
```

И посмотреть на дату модификации этого файла - она меняется в момент перехода в активную фазу.

## Оптимизация по слоям

Можно заметить наличие .dockerignore файла, а также то, что в packages.json находится довольно странное дублирование.
Результат билда в mail/calendar/calendar помещается в два каталога - внутрь deploy и lib. Возникает вопрос - а почему?
А так надо. Смотрите, что происходит. Когда разработчик правит календарь, он получает каталог mail/calendar/calendar, 
в котором куча jar, нужных для работы календаря, и сам calendar.jar. Весь каталог весит более 200 Мб. Но при этом 
calendar.jar весит всего 7. В изначальном варианте образа мы копировали каталог deploy командой COPY. Это значит,
что хотя разработчик изменил одну строку, которая привела к изменению calendar.jar на 7 Мб, docker породит слой
размером более 200 Мб.  Это мы будем еще и пересылать по сети во время пушей и пуллов. Это настолько безобразное 
расходование средств, что у автора данных строк не хватает словарного запаса, чтобы выразить всю гамму ощущений.

Казалось бы, самое простое, это как-то модифицировать ya.make либо package.json, чтобы ya помещал все зависимости в один
каталог, а выходной calendar.jar в другой, и копировать сначала первый каталог (который всегда будет в кеше), а затем
calendar.jar, но, как оказалось, это сделать не так просто, точнее, невозможно штатными средствами ya. Поэтому
мы воспользовались .dockerignore. Он игнорит в каталоге deploy calendar.jar, и берет его из lib. В результате все получается красиво. Что это дает?

* Когда разработчик делает образ у себя, билд образа теперь укладывается секунды в 3 (я говорю именно про фазу
билда самого образа, сколько перед этим собирается calendar.jar, вопрос отдельный).
* push образа тоже теперь укладывается секунд в 5 точно.
* Гипотетически это ускоряет и выкладку в QLoud, когда он выкачивает образы из сети.
* Экономию места в репозитории Яндекс. Если раньше каждый новый образ требовал дополнительных 200 Мб, то теперь
он требует 7 Мб (если, конечно, не менялись зависимости, а чаще всего они неизменны).

Отдельно поставлен ignore на библиотечку .so для работы с TVM, поскольку ее необходимо переместить в /usr/lib,
и для этого также модифицирован package.json.

## Обеспечение гладкой выкатки

Внимательный читатель может заметить наличие некоего скрипта /opt/start.py, который
запускается супервизором и слушает локально порт 23456. Что это такое? А это, 
дорогие друзья, следствие того, что Qloud не может нормально оповестить 
L3 балансер, что инстанс редеплоится, чтобы его сняли с анонса. Поэтому что мы делаем:

* Запускаем скрипт, который слушает порт.
* Ставим на компонент http stop hook, который стучится в этот порт.
* Когда скрипт получает сигнал по этому порту, он заставляет nginx релоадить конфигурацию,
заставляя его по ручке /ping возвращать 503. Все остальные ручки обслуживаются как есть.
* Через stop hook timeout Qloud посылает супервизору сигнал, чтобы он все остановил. Поэтому
этот таймаут должен быть больше 10 секунд - за это время балансер наконец допетрит, что
инстанс не особо работоспособен, и перестанет лить на него трафик. 

Т.е. мы обслуживаем остальные запросы в течение этого таймаут, но новые балансер присылать перестанет,
это должно позволить избежать кучи 5хх на фронте, поскольку там максимум один ретрай,
а повышать до двух как-то не хочется.