from functools import partial
from typing import Callable

from ticket_parser2.api.v1 import TvmClient

from .blackbox_client import BlackboxClient

TicketProdiver = Callable[..., str]


def service_ticket_tvm_provider(tvm_client: TvmClient, dst_alias: str = None, dst_client_id: int = None) -> TicketProdiver:
    return partial(tvm_client.get_service_ticket_for, alias=dst_alias, client_id=dst_client_id)


def user_ticket_by_oauth_provider(blackbox_client: BlackboxClient, oauth_token: str) -> TicketProdiver:
    return partial(blackbox_client.user_ticket_by_oauth, oauth_token=oauth_token)


def fixed_ticket_provider(ticket: str) -> TicketProdiver:
    return lambda: ticket
