import sys
import importlib

from mail.calendar.python.scripts import ENTRYPOINTS_TO_MODULE


def main():
    entrypoints_prompt = "|".join(ENTRYPOINTS_TO_MODULE.keys())
    if len(sys.argv) < 2:
        print(f'usage: {sys.argv[0]} {entrypoints_prompt} --help')
        sys.exit(0)

    module_name = ENTRYPOINTS_TO_MODULE.get(sys.argv[1])
    if not module_name:
        print(f'invalid operation requested, valid choices: {entrypoints_prompt}')
        return
    # Remove op name
    sys.argv = sys.argv[:1] + sys.argv[2:]
    importlib.import_module('mail.calendar.python.scripts.' + module_name).main()
