from configparser import RawConfigParser
from dataclasses import dataclass

from ticket_parser2.api.v1 import BlackboxClientId

from typing import TextIO


@dataclass
class UserCreds:
    uid: int
    login: str
    oauth: str


def creds_from_propfile(env: BlackboxClientId, actor_oauth_propfile: TextIO, login: str) -> UserCreds:
    domain_prefix = 'yt' if env in (BlackboxClientId.ProdYateam, BlackboxClientId.TestYateam) else 'public'
    # config parser requires properties file to have a section
    section_name = 'section'
    conf = RawConfigParser()
    conf.read_string(f'[{section_name}]\n' + actor_oauth_propfile.read())
    try:
        return UserCreds(
            login=login,
            uid=int(conf[section_name][f'{domain_prefix}.{login}.uid']),
            oauth=conf[section_name][f'{domain_prefix}.{login}.oauth'],
        )
    except KeyError as e:
        raise RuntimeError(f'Property {e} is not set in propfile')
