import asyncio

from client.cerberus_client import CerberusClient, Resource
from client.db_client import DbClient, LayerInfo
from client.db_client import DbSettings


def convert(layer_info: LayerInfo) -> Resource:
    return Resource(id=layer_info.id, type='layer', name=layer_info.name or "", active=True, location=None, info=None)


async def main():
    batch_size = 800
    db_settings = DbSettings(
        host='',
        port=6432,
        dbname='',
        user='',
        password='',
        timeout_sec=5
    )
    tvm_ticket = ''

    db = DbClient(db_settings, dry_run=False)
    cerberus = CerberusClient(url=CerberusClient.PUBLIC_CERBERUS_TESTING_URL)

    await db.connect(pool_size=10)
    await db.ping()

    next_id = -1

    print("Start migration")
    while next_id is not None:
        print(f'Fetch batch starting with id = {next_id}')
        batch = await db.select_layers(batch_size=batch_size, since_id=next_id)
        print(f'Received {len(batch)} layers')

        cerberus_resources = [convert(layer_info) for layer_info in batch]
        await cerberus.add_resources(resources=cerberus_resources, skip_existing=True, service_tvm_ticket=tvm_ticket)
        print("Batch migration complete")
        next_id = max((layer_info.id for layer_info in batch), default=None)
    print("Migration complete")


if __name__ == '__main__':
    asyncio.run(main())
