from collections import Counter
from datetime import datetime, timedelta

import click

from mail.calendar.python.client.calendar_client import CalendarClient

from .helpers import calendar_client_options


@click.command()
@click.option('--office-id', default=1)
@click.option('--exchange-name', default='conf_rr_1_29@yandex-team.ru')
@click.option('--from-date', type=click.DateTime(), default=datetime.now().date().isoformat())
@click.option('--to-date', type=click.DateTime(), default=(datetime.now().date() + timedelta(days=1)).isoformat())
@calendar_client_options
def main(cli: CalendarClient, office_id, from_date, to_date, exchange_name, **_):
    """Get organizators of events in room/resource by given date range"""
    room_schedule = cli.get_resources_schedule([office_id], from_date, to_date, exchange_name)
    event_ids = set(event['eventId'] for event in room_schedule['offices'][0]['resources'][0]['events'])
    event_infos = cli.get_events_brief(event_ids)
    orgs = Counter(event['organizer']['email'] for event in event_infos['events'])
    for org, events_count in orgs.most_common():
        print(org, events_count)
    # print(json.dumps(event_infos, indent=4))
