importPackage(java.lang);
importPackage(java.util);
importPackage(ru.yandex.misc.time);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.user);
importPackage(ru.yandex.calendar.logic.beans);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.calendar.util.base);

deps = staff.groups().getDepartments().withPageSize(100500).toList();
depByUrl = deps.toMapMappingToKey(function(d) { return d.getUrl() } );

depMap = Cf.list(
    'yandex_design', // Департамент дизайна
    'yandex_media',  // Направление медиасервисов
    'yandex_proffice', // Офис по связям с общественностью
    'yandex_ctoffice', // Офис по распространению технологий
    'yandex_personal', // Направление персональных сервисов
    'yandex_infra', // Направление инфраструктуры
    'yandex_edu', // Департамент оргразвития и управления персоналом
    'yandex_biz', // Департамент продаж и развития бизнеса
    'yandex_monetize', // Направление рекламных технологий
    'yandex_mrkt', // Департамент рекламы и маркетинга
    'yandex_rkub_portal', // Поисковый портал
    'yandex_monetize_market', // Направление продукта Маркет
    'yandex_distribution', // Направление дистрибуционных продуктов
    'yandex_mnt', // Департамент эксплуатации
    'yandex_build', // Департамент строительства, инженерных систем и административных вопросов
    'heads', // Руководство
    'yandex_personal_vertserv', // Вертикальные сервисы
    '', // Направление монетизации
    'yandex_biz_com', // Коммерческий департамент
    'yandex_content', // Карты и контент-сервисы
    'yandex_rkub_taxi', // Я. Такси
    'yandex_rkub_bromobtech', // Направление браузера и мобильных технологий
    'yandex_int', // Группа международного развития
    'yandex_factory' // Yandex Data Factory
).zipWithIndex()
    .toMap(function(t) {
        return Tuple2.tuple(String(t.get1()), t.get2() + 1);
    });

findDepNum = function(url) {
    if (url.equals(String('yandex')) || url.equals(String('yandex_rkub'))) {
        return depMap.get('heads');
    }
    return Cf.list(depByUrl.getOrThrow(url, 'no department for ' + url)
        .getAncestors().map(function(d) { return d.getUrl() })).plus1(url).reverse()
        .filterMap(function(url) { return depMap.getO(url) })
        .firstO().getOrElse(depMap.size() + 2);
};

repr = function(e, range) {
    var quote = function(s) {
        return s.replaceAll('\\|', '_').replaceAll('\n', '\\\\n').replace('\t', '\\\\t');
    };
    var fit = function(dt, left) {
        dt = dt.toDateTime(tz);

        return dt.isBefore(range.getStart())
            ? range.getStart().minus(left ? 1 : 0).toDateTime(tz)
            : range.getEnd().exists(function(e) { return !e.isAfter(dt) })
            ? range.getEnd().get().minus(left ? 1 : 0).toDateTime(tz)
            : dt;
    };
    var date = function(dt) {
        return fit(dt).toLocalDateTime().toString("YYYY-MM-dd HH:mm");
    };
    var invitee = function(p) {
        var login = p.getLogin();

        if (login.isDefined()) {
            var depO = userManager.getYtUserByLogin(login.get())
                .getOrThrow("no user for " + login.get())
                .getDepartment();

            if (depO.isDefined()) {
                return Cf.list(p.getName(), login.get() + "@", String(findDepNum(depO.get().getUrl()))).map(quote).mkString('|');
            }
        }
        return Cf.list(p.getName(), p.getEmail().getEmail()).map(quote).mkString('|');
    };

    var event = e.getEventWithRelations();

    var interval = event.getEventInterval(e.getRepetitionInstanceInfo().getEventInterval()),
        attendees = event.getParticipants().getUserAttendeesButNotOrganizer().map(invitee),
        organizer = invitee(event.getParticipants().getOrganizer());

    var nights = new Duration(
        fit(interval.getStart(), true).withTimeAtStartOfDay(),
        fit(interval.getEnd(), true).withTimeAtStartOfDay()).getStandardDays();

    if (nights <= 0) {
        return "";
    }

    return Cf.list(
        date(interval.getStart()),
        date(interval.getEnd()),
        nights,
        quote(event.getEvent().getDescription()),
        organizer
    ).plus(Cf.range(0, 10).map(function(i) { return attendees.getO(i).getOrElse("") })).mkString('\t');
};

tz = MoscowTime.TZ;

port = function(exchangeName, since, till) {
    var resource = resourceRoutines.findByExchangeName(exchangeName).getOrThrow("no resource for " + exchangeName);

    var interval = new InfiniteInterval(
        since.toDateMidnight(tz).toInstant(),
        till.map(function(date) { return date.toDateMidnight(tz).toInstant() }));

    var events = eventInfoDbLoader.getEventInfosOnResources(
        Option.none(), EventGetProps.any(), Option.some(resource.getId()),
        EventLoadLimits.intersectsInterval(interval), ru.yandex.calendar.logic.event.ActionSource.WEB);

    events = events
        .sortedBy(function(e) { return e.getRepetitionInstanceInfo().getEventInterval().getStart() })
        .filterMap(function(e) { return Option.some(repr(e, interval)).filter(ru.yandex.misc.lang.StringUtils.notEmptyF()) });

    return Cf.list("#" + resource.getNameEn().get().replaceAll('/', ', ')).plus(events).mkString('', '\n', '\n');
};

exportInterval = function(since, till, file) {
    file = file || since.toString("YYYYMMdd-") + till.toString("YYYYMMdd") + '.tsv';

    file = new ru.yandex.misc.io.file.File2('/var/log/corba/calendar/' + file);

    file.asOutputStreamTool().write('');

    var resources = Cf.range(24, 28).plus(Cf.range(1, 15)).plus(Cf.range(19, 22)).plus1(18).plus1(30)
        .map(function(n) { return 'apartment_msk_' + n });

    resources.forEach(function(r) {
        file.asAppendOutputStreamTool().write(port(r, since, Option.some(till)));
    });
};

exportMonth = function(month, year) {
    var start = new LocalDate(year || new LocalDate(tz).getYear(), month, 1);

    return exportInterval(start, start.plusMonths(1), start.toString("MMMM").toLowerCase() + '.tsv');
};

exportInterval(new LocalDate(2016, 1, 1), new LocalDate(2016, 6, 1));

