importPackage(ru.yandex.misc.email);
importPackage(ru.yandex.misc.time);
importPackage(ru.yandex.calendar.frontend.ews);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.calendar.logic.resource);
importPackage(ru.yandex.calendar.frontend.ews.exp);
importPackage(ru.yandex.calendar.util.base);
importPackage(ru.yandex.calendar.logic.sharing.participant);


mes = mainEventDao.findMainEventsByIds(Cf.list(761274, 761919).map(Cf.Double.toLongF()));
meis = eventInfoDbLoader.getMainEventInfos(Option.none(), mes, ActionSource.PERFORMER);

importMeeting = function(exchangeId, resourceId) {
    var item = ewsProxyWrapper.getEvents(Cf.list(exchangeId)).single();
    var actionInfo = ActionInfo.adminManager();
    var id = UidOrResourceId.resource(resourceId);

    return ewsImporter.createOrUpdateEventWithRecurrences(id, item, actionInfo, false);
};

updateParticipants = function(mei, resourceId) {
    var consUpdateParticipantsData = function(ei) {
        return eventToCalendarItemConverter.convertToChangeDescriptions(
                ei.getEventWithRelations(),
                ei.getRepetitionInstanceInfo(),
                EventChangesInfoForExchange(Event(), Repetition(), true, Cf.list()));
    };
    var stored = mei.getEventInfos().flatMapO(f(function(ei) {
        var resources = partition(ei.getEventWithRelations(), resourceId);

        if (resources.ourP.isEmpty()) return Option.none();

        return Option.some(updateMeeting(resources.ourP.get(), consUpdateParticipantsData(ei)));
    }));

    stored.forEach(f1V(function(s) { saveUpdateExchangeId(s); }));
    return stored;
};

recreateMeeting = function(mei, resourceId) {
    var master = mei.getMasterEventsWithRelations().single();
    var recurrences = mei.getRecurrenceEventsWithRelations();

    var stored = Cf.arrayList();
    var data = convert(mei);

    var masterResources = partition(master, resourceId);
    if (masterResources.ourP.isDefined()) {
        stored.add(createMeeting(masterResources.ourP.get(), data.masterData.createData));
        data.masterData.exdates.forEach(f1V(function(start) { cancelOccurrence(stored.first(), start); }));
    }

    recurrences.forEach(f1V(function(ewr) {
        var rs = partition(ewr, resourceId);
        var dt = data.recurrencesData.apply(ewr.getRecurrenceId().get());

        if (masterResources.ourP.isEmpty()) {
            stored.add(createMeeting(rs.ourP.get(), dt.createData));
        } else if (rs.ourP.isDefined()) {
            stored.add(modifyOccurrence(rs.ourP.get(), stored.first(), ewr.getRecurrenceId().get(), dt.updateData));
        } else {
            cancelOccurrence(stored.first(), ewr.getRecurrenceId().get());
        }
    }));

    lastUpdateManager.updateMainEventAndLayerTimestamps(Cf.list(master.getEvent().getId()), ActionInfo.adminManager());
    stored.forEach(f1V(function(s) { saveUpdateExchangeId(s); }));
    return stored;
};

saveUpdateExchangeId = function(s) {
    eventResourceDao.saveUpdateExchangeId(s.resourceId, s.eventId, s.exchangeId, ActionInfo.adminManager());
};

partition = function(ewr, resourceId) {
    var p = ewr.getResourceParticipantsYaTeamAndSyncWithExchange()
            .partition(ResourceParticipantInfo.getResourceIdF().andThenEquals(java.lang.Long.valueOf(resourceId)));

    return {
        ourP: p._1.singleO(),
        otherP: p._2
    }
};

createMeeting = function(resourceP, createData) {
    var email = resourceRoutines.getExchangeEmail(resourceP.getResource());
    return {
        eventId: resourceP.getEventId(),
        resource: resourceP.getResource(),
        resourceId: resourceP.getResourceId(),
        exchangeId: ewsProxyWrapper.createEvent(email, createData)
    }
};

updateMeeting = function(resourceP, updateData) {
    var id = EwsModifyingItemId.fromExchangeId(resourceP.getExchangeId().getOrThrow('no exchange id for ' + resourceP));
    return {
        eventId: resourceP.getEventId(),
        resourceId: resourceP.getResourceId(),
        exchangeId: ewsProxyWrapper.updateItem(id, updateData).getOrThrow('failed to update meeting for ' + resourceP)
    };
};

modifyOccurrence = function(resourceP, createdMaster, start, updateData) {
    var id = EwsModifyingItemId.fromExchangeId(getOccurrenceId(createdMaster, start));
    return {
        eventId: resourceP.getEventId(),
        resourceId: resourceP.getResourceId(),
        exchangeId: ewsProxyWrapper.updateItem(id, updateData).get()
    }
};

cancelOccurrence = function(createdMaster, start) {
    ewsProxyWrapper.cancelMeetingsSafe(Cf.list(getOccurrenceId(createdMaster, start)))
};

getOccurrenceId = function(createdMaster, start) {
    var email = resourceRoutines.getExchangeEmail(createdMaster.resource);
    var interval = InstantInterval(start, start);
    var instanceIds = ewsProxyWrapper.findInstanceEventIds(email, interval);

    return ewsProxyWrapper.findRecurringMasterIdsByInstanceIds(instanceIds)
            .findBy2(Cf2.isSomeF(createdMaster.exchangeId)).get().get1();
};

convert = function(mei) {
    var master = mei.getMasterEventInfos().single();
    var recurrences = mei.getRecurrenceEventInfos();

    var masterData = {
        createData: eventToCalendarItemConverter.convertToCalendarItem(
                master.getEventWithRelations(),
                master.getRepetitionInstanceInfo()),

        exdates: master.getRepetitionInstanceInfo().getExdates().map(Rdate.getStartTsF())
    };
    var recurrencesData = Cf.hashMap();
    recurrences.forEach(f1V(function(recurrence) {
        recurrencesData.put(recurrence.getRecurrenceId().get(), {
            createData: eventToCalendarItemConverter.convertToCalendarItem(
                    recurrence.getEventWithRelations(),
                    recurrence.getRepetitionInstanceInfo()),

            updateData: eventToCalendarItemConverter.convertToChangeDescriptions(
                    recurrence.getEventWithRelations(),
                    recurrence.getRepetitionInstanceInfo(),
                    eventChangesFinder.getEventChangesInfoForExchangeForNewRecurrence(master.getEvent(), recurrence.getEvent()))
        });
    }));
    return {masterData: masterData, recurrencesData: recurrencesData};
};
