importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.misc.email);
importPackage(ru.yandex.misc.time);
importPackage(ru.yandex.calendar.frontend.ews);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.beans);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.calendar.logic.resource);
importPackage(ru.yandex.calendar.logic.user);
importPackage(ru.yandex.calendar.frontend.ews.exp);
importPackage(ru.yandex.calendar.util.base);
importPackage(ru.yandex.calendar.logic.sharing.participant);
importPackage(com.microsoft.schemas.exchange.services._2006.types);

logger = ru.yandex.misc.log.mlf.LoggerFactory.getLogger('ews fix timezones');
lookupInterval = new InstantInterval(MoscowTime.instant(2015, 7, 1, 0, 0), MoscowTime.instant(2015, 9, 1, 0, 0));

loadExchangeInstances = function(exchangeIds) {
    var fields = Cf.list(
        UnindexedFieldURIType.CALENDAR_UID,
        UnindexedFieldURIType.CALENDAR_CALENDAR_ITEM_TYPE,
        UnindexedFieldURIType.CALENDAR_START,
        UnindexedFieldURIType.CALENDAR_END);

    return ewsProxyWrapper.getEvents(exchangeIds, fields, Cf.list());
};

findExchangeInstances = function(email, interval) {
    var fields = Cf.list(
        UnindexedFieldURIType.CALENDAR_UID,
        UnindexedFieldURIType.CALENDAR_CALENDAR_ITEM_TYPE,
        UnindexedFieldURIType.CALENDAR_START,
        UnindexedFieldURIType.CALENDAR_END);

    return ewsProxyWrapper.findInstanceEvents(email, interval, fields, Cf.list());
};

findCalendarEvents = function(email, interval) {
    var uid = userManager.getYtUserByEmail(email)
        .getOrThrow('user not found by email ' + email)
        .getUid().map(PassportUid.consF())
        .getOrThrow('no uid specified for user ' + email);

    var events = eventInfoDbLoader.getEventsOnLayers(
        EventGetProps.any(),
        invoke(eventRoutines, 'getLayerIds', LayerIdPredicate.allForUser(uid, false)),
        EventLoadLimits.intersectsInterval(interval));

    var mainEvents = mainEventDao.findMainEventsByEventIds(events.map(EventAndRepetition.getEventIdF()));

    var externalIdByMainEventId = mainEvents.toMap(Bean.getIdF(), MainEvent.getExternalIdF());

    var externalIdByEventId = events.toMap(
        EventAndRepetition.getEventIdF(),
        EventAndRepetition.getEventF().andThen(Event.getMainEventIdF()).andThen(externalIdByMainEventId.asFunction()));

    return events.toMapMappingToKey(EventAndRepetition.getEventIdF().andThen(externalIdByEventId.asFunction()));
};

wrongTzIds = Cf.list(
    'Asia/Magadan', 'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Sakhalin',
    'Asia/Ust-Nera', 'Asia/Vladivostok', 'Asia/Yakutsk', 'Asia/Yekaterinburg',
    'Europe/Kaliningrad', 'Europe/Moscow', 'Europe/Simferopol', 'Europe/Volgograd'
).map(function(id) { return new java.lang.String(id) });

hasWrongTimezone = function(calItem) {
    var timezone = calItem.getStartTimeZone();

    if (timezone == null) return false;

    var groups = timezone.getTransitionsGroups().getTransitionsGroup();

    if (groups.size() != 1 || groups.get(0).getTransition().size() != 2) return false;

    var transitionDayMonths = Cf.x(groups.get(0).getTransition())
        .map(function(jaxb) { return jaxb.getValue() })
        .filterByType(RecurringDateTransitionType.class)
        .map(function(transition) { return transition.getMonth() * 100 + transition.getDay() });

    return transitionDayMonths.size() == 2
        && (transitionDayMonths.first() == 101 && transitionDayMonths.last() == 1026
        || transitionDayMonths.last() == 101 && transitionDayMonths.first() == 1026);
};

fixInstanceTimezone = function(item, eventByExternalId) {
    var repr = JSON.stringify({
        type: item.getCalendarItemType().value(),
        uid: item.getUID(),
        id: item.getItemId().getId()
    });

    var result = function(status) {
        return {
            status: status,
            uid: item.getUID()
        }
    };

    if (!eventByExternalId.containsKey(item.getUID())) {
        logger.warn('Event not found in Calendar: ' + repr);
        return result('not-found');
    }
    if (item.getCalendarItemType() != CalendarItemTypeType.SINGLE) {
        logger.info('Skip occurrence because of type: ' + repr);
        return result('not-single');
    }
    var event = eventByExternalId.apply(item.getUID()).getEvent(),
        eventTz = eventByExternalId.apply(item.getUID()).getRepetitionInfo().getTz(),
        toInstant = EwsUtils.xmlGregorianCalendarInstantToInstant;

    var distance = function(ts1, ts2) {
        return ts1.isBefore(ts2)
            ? new org.joda.time.Duration(ts1, ts2)
            : new org.joda.time.Duration(ts2, ts1);
    };
    var startDistance = distance(event.getStartTs(), toInstant(item.getStart())),
        endDistance = distance(event.getEndTs(), toInstant(item.getEnd()));

    if (startDistance.getMillis() == 0 && endDistance.getMillis() == 0) {
        logger.info('Skip occurrence with equal start and end: ' + repr);
        return result('equal-time');
    }
    if (!startDistance.isEqual(endDistance)) {
        logger.info('Skip occurrence with mismatching start and end distances: ' + repr);
        return result('start-end-distance-mismatch');
    }
    if (startDistance.isLongerThan(Duration.standardHours(1))) {
        logger.info('Skip occurrence with long start distance from event in Calendar: ' + repr);
        return result('too-far-start');
    }
    logger.info('Updating item start and end to ' + event.getStartTs() + '/' + event.getEndTs() + ' ' + repr);

    var startChange = function(instant, tz) {
        var item = new CalendarItemType();
        item.setStart(EwsUtils.instantToXMLGregorianCalendar(instant, tz));
        return EwsUtils.createSetItemField(item, UnindexedFieldURIType.CALENDAR_START)
    };
    var endChange = function(instant, tz) {
        var item = new CalendarItemType(); item.setEnd(EwsUtils.instantToXMLGregorianCalendar(instant, tz));
        return EwsUtils.createSetItemField(item, UnindexedFieldURIType.CALENDAR_END)
    };
    try {
        ewsProxyWrapper.updateItem(
            EwsModifyingItemId.fromExchangeId(item.getItemId().getId()),
            Cf.list(startChange(event.getStartTs(), eventTz), endChange(event.getEndTs(), eventTz)));
    } catch (e) {
        return result('update-failed');
    }
    return result('updated');
};

fixTimezones = function(email) {
    logger.info('Going to fix ' + email + ' ews events timezones');

    var instances = findExchangeInstances(email, lookupInterval);

    logger.info('Found ' + instances.count(hasWrongTimezone) + ' of ' + instances.size() + ' instances with wrong timezone');

    if (instances.count(hasWrongTimezone) == 0) return 'No meetings with wrong timezone';

    var events = findCalendarEvents(email, lookupInterval);

    var skippedRepeatingUids = Cf.hashSet(),
        statuses = {};

    instances.filter(hasWrongTimezone).map(function(instance) {
        var result = fixInstanceTimezone(instance, events, skippedRepeatingUids);

        if (result.status == 'not-single') {
            skippedRepeatingUids.add(result.uid);
        }
        statuses[result.status] = (statuses[result.status] || 0) + 1;
    });

    if (skippedRepeatingUids.isNotEmpty()) {
        logger.info('Skipped repeating meeting uids: ' + skippedRepeatingUids);
    }
    logger.info('Result: ' + JSON.stringify(statuses));

    statuses.skippedRepeatingUids = skippedRepeatingUids;
    return JSON.stringify(statuses);
};


loadExchangeNames = function(instances) {
    var exchangeId = function(i) { return i.getItemId().getId(); },
        subject = function(i) { return i.getSubject();},
        getEvents = function(ids) { return ewsProxyWrapper.getEvents(ids, Cf.list(UnindexedFieldURIType.ITEM_SUBJECT), Cf.list()) };

    var load = function(instances) {
        var exchangeIds = instances.map(exchangeId),
            calendarItemById = getEvents(exchangeIds).toMap(exchangeId, subject);

        var subjectById = calendarItemById.asFunctionOrElse(function(id) {
            return getEvents(Cf.list(id)).firstO().map(subject).getOrElse('?');
        });

        instances.forEach(function(i) {
            i.setSubject(subjectById.apply(exchangeId(i)));
        })
    };
    instances.paginate(10).forEach(load);
};


outExchangeInstance = function(instance) {
    var outTimezone = function() {
        if (instance.getStartTimeZone() == null) {
            return 'null';
        }
        var tz = instance.getStartTimeZone(),
            biases = Cf.x(tz.getPeriods().getPeriod()).map(function(p) { return p.getBias(); });
        return tz.getId() + ' (' + (biases.size() < 3 ? biases.mkString(' / ') : '...') + ')';
    };
    return Cf.list(
        instance.getCalendarItemType(), instance.getStart(),
        outTimezone(instance.getStartTimeZone()), instance.getSubject(), instance.getUID()).mkString(' ');
};

emailInstance = function(email, instance) {
    var mainEvents = mainEventDao.findMainEventsByExternalId(new ExternalId(instance.getUID()));

    if (mainEvents.isEmpty()) {
        out.println('No main event found for ' + instance.getUID());
        return;
    }
    if (mainEvents.size() > 1) {
        out.println('More than one main event found for ' + instance.getUID());
        return;
    }

    var masterEvents = eventDao.findMasterEventByMainId(mainEvents.single().getId());

    if (masterEvents.isEmpty()) {
        out.println('No master event found for ' + instance.getUID());
        return;
    }
    if (masterEvents.size() > 1) {
        out.println('More than one main event found for ' + instance.getUID());
        return;
    }
    out.println('Sending ' + masterEvents.single().getId()  + ' (' + instance.getUID() + ')...');
    send(email, masterEvents.single().getId());
};





email = 'whistler@yandex-team.ru';
instances = findExchangeInstances(new Email(email), lookupInterval);

instances = instances.sortedBy(function(i) { return i.getStart().toString(); });
indexed = instances.zipWithIndex();
indexed = indexed.stableUniqueBy(function(i) { return i.get1().getUID() });

loadExchangeNames(indexed.get1());

indexes = function(args) { return Cf.x(Array.prototype.slice.call(args, 0)).map(function(i) { return new java.lang.Integer(i) }); };


display = function() { return indexed.map(f(function(i) { return i.get2() + ' ' + outExchangeInstance(i.get1()) })); };
exclude = function() { indexed = indexed.filterBy2(indexes(arguments).containsF().notF()) };
keep = function() { indexed = indexed.filterBy2(indexes(arguments).containsF()) };


display();



indexed.get1().forEach(function(instance) { return emailInstance(email, instance) });
