importPackage(com.microsoft.schemas.exchange.services._2006.messages);

logger = ru.yandex.misc.log.mlf.LoggerFactory.getLogger('ews-requests');

target = getField(getField(getField(ewsProxy, 'h'), 'target'), 'proxy');

proxy = java.lang.reflect.Proxy.newProxyInstance(
    ewsProxy.getClass().getClassLoader(),
    [ExchangeServicePortType.class],
    function(proxy, method, args) {
        var request = args == null ? Option.none() : Cf.wrap(args).filterByType(BaseRequestType.class).firstO();

        if (request.isDefined()) {
            var w = new java.io.StringWriter();
            javax.xml.bind.JAXB.marshal(request.get(), w);
            logger.info(w.toString());
        }
        return args == null ? method.invoke(target) : method.invoke(target, args);
    });

setField(getField(getField(ewsProxy, 'h'), 'target'), 'proxy', proxy);
