importPackage(ru.yandex.bolts.collection);
importPackage(ru.yandex.calendar.logic.event);
importPackage(org.joda.time);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.calendar.logic.event.model);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.misc.email);
importPackage(ru.yandex.calendar.logic.sharing);
importPackage(ru.yandex.calendar.logic.contact);
importPackage(ru.yandex.calendar.logic.ics.exp);
importPackage(ru.yandex.calendar.logic.sending);
importPackage(ru.yandex.calendar.logic.sharing.participant);
importPackage(ru.yandex.commune.mail);
importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.misc.email);
importPackage(ru.yandex.misc.time);

//first load send function from "send invitation.js"
//TODO error will occur if the organizer doesn't have the right to book a room

uid = ru.yandex.inside.passport.PassportUid.cons(0);
eventIds = Cf.list();

actionInfo = new ActionInfo(ActionSource.WEB, "ewsMigration", Instant.now());
userInfo = userManager.getUserInfo(uid);

eventIds.forEach(function(eventId) {
    var recurrences = eventDbManager.getEventsByIds(eventRoutines.findMasterAndSingleEventIds(eventId)).map(
        function(e) {
            return e.getStartTs();
        }
    );
    var rdates = eventDao.findRdatesByEventId(eventId).map(
        function(e) {
            return e.getStartTs();
        }
    );

    var edge = recurrences.plus(rdates).plus(Instant.now()).max();

    var repetitionInfo = eventDbManager.getEventAndRepetitionById(eventId).getRepetitionInfo();
    var repetition = repetitionInfo.getRepetition().get().copy();

    var eventWR = eventDbManager.getEventWithRelationsById(eventId);
    var attendees = eventWR.getParticipants().getAttendees().map(function (i) {return i.getEmail();});

    var instantInterval = RepetitionUtils.getInstanceIntervalStartingAfter(repetitionInfo, edge).get();

    var cutRepetition = repetition.copy();
    cutRepetition.setDueTs(instantInterval.getStart());

    repetitionRoutines.createOrUpdateRepetition(Option.of(cutRepetition.getId()), cutRepetition);

    var cutEventAndRepetition = eventDbManager.getEventAndRepetitionByIdForUpdate(eventId);
    eventDbManager.updateEventLayersAndResourcesIndents(cutEventAndRepetition, actionInfo);

    lastUpdateManager.updateMainEventAndLayerTimestamps(Cf.list(eventId), actionInfo);

    notificationRoutines.recalcAllNextSendTs(eventId, actionInfo);

    repetition.unsetField(RepetitionFields.ID);

    var newEvent = eventWR.getEvent().copy();
    newEvent.unsetField(EventFields.ID);
    newEvent.unsetField(EventFields.MAIN_EVENT_ID);
    newEvent.unsetField(EventFields.REPETITION_ID);

    newEvent.setStartTs(instantInterval.getStart());
    newEvent.setEndTs(instantInterval.getEnd());

    var eventData = new EventData();
    eventData.setEvent(newEvent);

    var participantsOrInvitationData = ParticipantsOrInvitationsData.eventInvitationData(
        new EventInvitationsData(eventWR.getOrganizerEmailIfMeeting(),
            attendees.map(function (email) {return new EventInvitationData(email, Option.empty())})));

    eventData.setRepetition(repetition);
    eventData.setInvData(participantsOrInvitationData);
    eventData.setTimeZone(eventWR.getTimezone());

    eventWebManager.createUserEvent(uid, eventData, InvitationProcessingMode.SAVE_ATTACH_SEND, actionInfo);


    attendees.forEach(function(email) {
        try {
            send(email.toString(), eventId, false);
        } catch (exception) {
            out.println(email + ' ' + eventId);
        }
    })
});
