importPackage(ru.yandex.calendar.logic.resource);
importPackage(ru.yandex.calendar.frontend.ews.sync);
importPackage(com.microsoft.schemas.exchange.services._2006.types);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.inside.passport);

synchronizeBySubjectIdAndExchangeId = function(resourceId, exchangeId) {
    var calendarItem = ewsProxyWrapper.getEvent(exchangeId).getOrThrow('no event in exchange'),
        stats = newInstance(SyncStats.class),
        data = invoke(ewsImporter, 'convertExchangeData', resourceId, calendarItem, false);

    invoke(ewsImporter, 'createEventInner', resourceId, data.getEventData(), Option.none(), ActionInfo.adminManager());
    return stats;
};

synchronizeByResourceConflictId = function(conflictId) {
    var conflict = resourceConflictDao.findResourceConflictsByIds(Cf.list(java.lang.Long(conflictId))).first();

    return synchronizeBySubjectIdAndExchangeId(UidOrResourceId.resource(conflict.getResourceId()), conflict.getExchangeId());
};

synchronizeByUidAndExchangeId = function(uid, exchangeId) {
    return synchronizeBySubjectIdAndExchangeId(UidOrResourceId.user(uid), exchangeId);
};
