importPackage(java.lang);
importPackage(java.util);
importPackage(ru.yandex.misc.time);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.inside.passport);


resourceId = 38; // (38 Москва, 96 Питер)
from = DateMidnight(2012, 7, 1, MoscowTime.TZ);
to = DateMidnight(2012, 10, 15, MoscowTime.TZ);

interval = InfiniteInterval(from.toInstant(), Option.some(to.toInstant()));

events = eventInfoDbLoader.getEventsOnResources(EventGetProps.any(), Cf.list(resourceId), EventLoadLimits.intersectsInterval(interval));
instances = events.flatMap(EventAndRepetition.getInstancesInIntervalF(interval));

instancesByUid = instances.groupBy(EventInstanceInterval.getEventF().andThen(Event.getCreatorUidF()));
settingsByUid = settingsRoutines.getSettingsByUidBatch(instancesByUid.keys());

occupiers = instancesByUid.entries().map(f(function(t) {
    var millisF = EventInstanceInterval.getIntervalF().andThen(InstantInterval.toDurationMillisF());
    return {
        name : settingsByUid.apply(t._1).getUserName().getOrElse(''),
        email : settingsByUid.apply(t._1).getEmail(),
        totalMs : t._2.map(millisF).reduceLeft(Cf.Long.plusF()),
        count : t._2.size()
    }
}));

printMs = function(ms) {
    var h = Long.valueOf((ms / 1000 / 60) / 60);
    var m = Long.valueOf((ms / 1000 / 60) % 60);

    return (h > 0 ? h + ' ч. ' : '') + Formatter().format('%02d мин.', m);
};

printF = f(function(e) {
    return Cf.list(e.name, e.email, Long.valueOf(e.count), printMs(e.totalMs)).mkString('^');
});

occupiers.sortByDesc(f(function(e) { return e.totalMs; })).map(printF).mkString('\n');

/// NO END MASSAGE

es = eventInfoDbLoader.getEventsOnResources(
        EventGetProps.any(), Cf.list(38),
        EventLoadLimits.startsInInterval(InfiniteInterval(Instant.now(), Option.none())));
xes = es.filter(f1B(function(e) {
    if (e.getRepetitionInfo().isEmpty()) return false;

    var due = e.getRepetitionInfo().getRepetition().get().getDueTs();
    return !due.isDefined() || due.get().isAfter(DateTime(2012, 12, 21, 0, 0, MoscowTime.TZ))
}));
settingsByUid = settingsRoutines.getSettingsByUidBatch(xes.map(EventAndRepetition.getEventF().andThen(Event.getCreatorUidF())));

printF = f(function(x) {
    var printLocalTime = function(instant) {
        return instant.toDateTime(MoscowTime.TZ).toLocalTime().toString('H:mm');
    };
    var s = settingsByUid.apply(x.getEvent().getCreatorUid());

    return Cf.list(
            s.getUserName().getOrElse(''),
            s.getEmail(),
            printLocalTime(x.getEvent().getStartTs()) + ' - '
                    + printLocalTime(x.getEvent().getEndTs()) + ' с '
                    + x.getEvent().getStartTs().toDateTime(MoscowTime.TZ).toLocalDate() + ' '
                    + RepetitionToStringConverter.convert(x.getRepetitionInfo())
    ).mkString(' ');
});
xes.map(printF).mkString('\n');

/// FREE MASSAGE

interval = InfiniteInterval(DateMidnight(2013, 1, 20, MoscowTime.TZ).toInstant(), Option.none());

es = eventInfoDbLoader.getEventsOnResources(
        EventGetProps.any(), Cf.list(38),
        EventLoadLimits.startsInInterval(InfiniteInterval(Instant.now(), Option.none())));

es = es.filter(EventAndRepetition.getEventF().andThen(Event.getCreatorUidF().andThen(
        Cf.list(PassportUid(1120000000012705), PassportUid(1120000000012733), PassportUid(1120000000010945)).containsF().notF())));

is = es.flatMap(EventAndRepetition.getInstancesInIntervalF(interval));

occupiers = is
        .groupBy(EventInstanceInterval.getEventF().andThen(Event.getCreatorUidF()))
        .entries().filterBy2(Cf.List.sizeF().andThen(Cf.Integer.gtF(Integer(1))));

eIds = occupiers.flatMap(Tuple2.get2F()).map(EventInstanceInterval.getEventIdF()).stableUnique();

remover = userManager.getUserInfos(Cf.list(PassportUid(1120000000006832))).singleO();
mode = ru.yandex.calendar.logic.sharing.InvitationProcessingMode.SAVE_ATTACH_SEND;
actionInfo = ActionInfo.adminManager();

mails = Cf.list();
mails = mails.plus(eventRoutines.deleteEventsSafe(remover, eIds.drop(0).take(50), mode, actionInfo));
eventInvitationManager.sendEventMails(mails.drop(0).take(50), actionInfo);
