importPackage(ru.yandex.misc.email);
importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.calendar.logic.user);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.notification);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.inside.passport);

// this script is for some particular event; 
// in case of a series one could use main event id:
// mainEventId = 123456789; // achtung!!! it's a main, not a master!
// events = eventDao.findEventIdsByMainEventId(mainEventId);
// if (events.isEmpty()) {
//     print("Events not found");
// } else {
//     print("Found " + events.size() + " events. One of the events is a master event.");
//     for (var i = 0; i < events.size(); i++) {
//         var eventId = events.get(i);
//         print("Ev: " + eventId + "\n");
//         processEvent(eventId);
//     }
// }

eventId = 123456789;
// Keep these users as attendees
excludeList = Cf.list('user_login1', 'user_login_2');

asUser = 'robot-calendar@yandex-team.ru';

query = "SELECT eu.uid, s.email \
FROM event_user AS eu \
INNER JOIN settings AS s USING (uid) \
WHERE eu.event_id = ? \
  AND eu.is_attendee \
  AND NOT eu.is_organizer \
  AND eu.decision != 'no' \
  AND s.user_login NOT " + SqlQueryUtils.inSet(excludeList);

actionInfo = new ActionInfo(ActionSource.PERFORMER, "req-id-script-replace-attendee-by-subscriber", Instant.now());
rootUserUid = userManager.getUidByEmail(new Email(asUser)).get();
rootUserInfo = userManager.getUserInfo(rootUserUid);

function move(eventId, userUid, userEmail) {
    removeRes = eventInvitationManager.removeAttendeeByEmail(eventId, rootUserInfo, new Email(userEmail), actionInfo);
    if (removeRes.isEmpty()) {
        print("cant remove user " + userEmail + " from event " + eventId);
    } else {
        eventUser = new EventUser();
        eventUser.setIsSubscriber(true);
        userInfo = userManager.getUserInfo(userUid);
        superUserInfo = new UserInfo(userInfo.getUid(), java.util.EnumSet.of(Group.SUPER_USER), Cf.list(), Cf.list(), false, false, false);
        eventWebManager.attachEvent(superUserInfo, eventId, Option.empty(), eventUser, new NotificationsData.UseLayerDefaultIfCreate(), actionInfo);
    }
}

function processEvent(eventId) {
    attendeeUids = eventLayerDao.getJdbcTemplate().queryForList2(query, java.lang.Long.class, java.lang.String.class, eventId);
    uids = attendeeUids.get1();
    emails = attendeeUids.get2();
    count = uids.size();
    for (var i = 0; i < count; i++) {
        print(uids[i] + ": " + emails[i]);
        move(eventId, PassportUid.cons(uids[i]), emails[i]);
    }
}

processEvent(eventId);
