importPackage(org.yoda.time);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.calendar.logic.contact);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.ics.exp);
importPackage(ru.yandex.calendar.logic.notification);
importPackage(ru.yandex.calendar.logic.sending);
importPackage(ru.yandex.calendar.logic.sending.param);
importPackage(ru.yandex.calendar.logic.sharing);
importPackage(ru.yandex.calendar.logic.sharing.participant);
importPackage(ru.yandex.commune.mail);
importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.misc.email);
importPackage(ru.yandex.misc.time);


// batchAttachToEvent(Cf.list('login1', 'login2'), 1234);
// Добавляет пользователям встречу в календарь. участниками они при этом не становятся,
// и, благодаря этому, ics'ка не становится неподъемной.
// Outlooker'ам при этом автоматически отправляется письмо, чтобы встреча появилась у них в Exchange
// Дополнительно к этому отправляется человекочитаемое письмо для не-exchange
// ВНИМАНИЕ: так как используется механизм "добавить себе в календарь",
// то при попытке добавить людей в отредактированный повтор, они добавятся во все повторы и мастер-серию.
//
// Если всё-таки случайно добавили не туда, и теперь хочется всех убрать, не привлекая внимания и не отправляя писем,
// то можно сделать так (так как письма об удалении не отправятся, то надо применять аккуратно,
// и, как минимум потом отдельно почистить встречи в Exchange у ewser'ов):
//
// uids = Cf.list(1, 2, 3).map(function(uid) {return new PassportUid(uid)});
// eventIds = Cf.list(1234);
// batchDetachFromEventQuiet(uids, eventIds)
//

send = function(email, eventId) {
    email = new ru.yandex.misc.email.Email(email);
    eventId = new java.lang.Long(eventId);

    var uid = userManager.getUidByEmail(email).getOrThrow("not yandex user");
    var user = userManager.getYtUserByEmail(email).getOrThrow("not staff user");
    var event = eventDbManager.getEventWithRelationsById(eventId);

    var participantInfo = new YandexUserParticipantInfo(eventUserDao.findEventUserByEventIdAndUid(eventId, uid).get(), settingsRoutines.getSettingsByUid(uid));

    var sendingInfo = new EventSendingInfo(
        participantInfo,
        MailType.EVENT_INVITATION, EventInstanceParameters.fromEvent(event.getEvent()), Option.none()).withDestination(MessageDestination.NOT_FOR_EXCHANGE);

    return eventInvitationManager.createAndSendEventInvitationOrCancelMails(
        ActorId.yaCalendar(), Cf.list(sendingInfo), ActionInfo.adminManager());

};

function batchAttachToEvent(logins, eventId) {
    uids = logins.filterMap(function (login) {return userManager.getYtUserUidByLogin(login)});
    actionInfo = new ActionInfo(ActionSource.MAIL, "attach-event", Instant.now());

    uids.forEach(function (uid) {
        user = userManager.getUserInfo(uid);
        eventUser = new EventUser();
        eventUser.setIsSubscriber(true);
        eventUser.setDecision(Decision.YES);
        eventWebManager.attachEvent(user, eventId, Option.empty(),
            eventUser, NotificationsData.useLayerDefaultIfCreate(), actionInfo);

        userManager.getEmailByUid(uid).forEach(function (email) {
            send(email.toString(), eventId)
        })

    })
}

function findEventLayersByEventIdAndLayerCreatorUids(eventId, layerCreatorUids){
    q = "SELECT * FROM event_layer WHERE event_id = ? AND l_creator_uid " + SqlQueryUtils.inSet(layerCreatorUids);

    return eventLayerDao.getJdbcTemplate().queryForList(q, EventLayer.class, eventId);
}

function batchDetachFromEventQuiet(uids, eventIds) {
    eventIds.forEach(function(eventId) {
        el_ids = findEventLayersByEventIdAndLayerCreatorUids(eventId, uids).map(function (el) {return EventLayerId.of(el);});

        eventLayerDao.deleteEventLayersByIds(el_ids);

        eus = eventUserDao.findEventUsersByEventIdsAndUids(Cf.list(eventId), uids).map(function(eu) {return eu.getId()});

        notificationDao.deleteEventNotificationsByEventUserIds(eus);

        uids.forEach(function(uid) {
            eventUserDao.deleteEventUserForEventAndUser(eventId, uid);
        });

        eventDao.updateEventIncrementSequenceById(eventId);
    });
}
