importPackage(ru.yandex.calendar.logic.resource);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.event.avail);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.misc.time);

uid = ru.yandex.inside.passport.PassportUid.cons(1120000000018594);

spbResources = resourceRoutines.getDomainResourcesCanBookWithLayersAndOffices(
    uid, Tuple2List.fromPairs(new java.lang.Long(2), ResourceFilter.any().withFilter('video,large')));

priority = Cf.list('conf_spb_kunstkamera', 'conf_spb_bkz', 'conf_spb_dvorec').map(String).zipWithIndex().toMap();
spbResources = spbResources.sortedBy(function(r) {
    return priority.getO(r.getResource().getExchangeName().get()).getOrElse(100500)
});

minskResources = resourceRoutines.getDomainResourcesCanBookWithLayersAndOffices(
    uid, Tuple2List.fromPairs(new java.lang.Long(151), ResourceFilter.any().withFilter('video')));

eventId = new java.lang.Long(2075261);
repetition = repetitionRoutines.getRepetitionInstanceInfoByEventId(eventId);

function startDate(interval) {
    return new LocalDate(interval.getStart(), MoscowTime.TZ);
}

function dates() {
    return getField(RepetitionInstanceSet.boundedByMaxCheckPeriod(repetition, Instant.now()), 'instances').getIntervals().map(startDate);
}

function overlappingDates(resource) {
    var avails = availRoutines.getAvailabilityIntervals(
        uid, SubjectId.resourceId(resource.getResourceId()),
        AvailabilityRequest.intervals(RepetitionInstanceSet.boundedByMaxCheckPeriod(repetition, Instant.now())),
        ActionInfo.adminManager());

    return avails.getIntervals().getIntervals().map(startDate).stableUnique();
}

function countOverlaps(resource) {
    return overlappingDates(resource).size();
}

function reprResource(resource) {
    return resource.getResource().getName().get();
}

spbResources.zipWith(countOverlaps).map1(reprResource);


function findVariant() {
    var spb = spbResources.zipWith(overlappingDates),
        minsk = minskResources.zipWith(overlappingDates);

    return dates().zipWith(function(date) {
        return Tuple2.tuple(
            spb.findBy2(Cf.List.containsF().notF().bind2(date)).map(function(t) { return reprResource(t.get1())}),
            minsk.findBy2(Cf.List.containsF().notF().bind2(date)).map(function(t) { return reprResource(t.get1())}));
    });
}

function countFilled(variant) {
    return variant.get2().count(function(t) { return t.get1().isDefined() && t.get2().isDefined() })
}

function isFullFilled(variant) {
    return countFilled(variant) == variant.size();
}

eventId = new java.lang.Long(1875496);
repetition = repetitionRoutines.getRepetitionInstanceInfoByEventId(eventId);

function findForInterval(interval) {
    setField(repetition, 'eventInterval', interval);
    return findVariant();
}

Cf.list(
    new InstantInterval(MoscowTime.instant(2015, 3, 2, 16, 0), MoscowTime.instant(2015, 3, 2, 17, 30)),
    new InstantInterval(MoscowTime.instant(2015, 3, 2, 16, 30), MoscowTime.instant(2015, 3, 2, 18, 0)),
    new InstantInterval(MoscowTime.instant(2015, 3, 2, 16, 30), MoscowTime.instant(2015, 3, 2, 18, 30)),
    new InstantInterval(MoscowTime.instant(2015, 3, 2, 16, 30), MoscowTime.instant(2015, 3, 2, 19, 0)),
    new InstantInterval(MoscowTime.instant(2015, 3, 2, 16, 30), MoscowTime.instant(2015, 3, 2, 19, 30))).zipWith(findForInterval);

variants = Cf.range(2, 32).zipWith(function(d) {
    var interval = new InstantInterval(MoscowTime.instant(2015, 3, d, 15, 0), MoscowTime.instant(2015, 3, d, 18, 0));

    if (new LocalDate(2015, 3, d).getDayOfWeek() > 5) return Option.none();

    setField(repetition, 'eventInterval', interval);

    var variant = findVariant();

    return Tuple2.tuple(countFilled(variant), variant);
});

variants.sortedBy2Desc(function(t) { return t instanceof Option ? 0 : t.get1() });
