importPackage(java.lang);
importPackage(java.util);
importPackage(ru.yandex.misc.time);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.calendar.logic.resource);
importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.inside.passport.blackbox);
importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.calendar.logic.sharing);

f = function(func) { return new F() { apply: function x(a) { return func(a); } } };
f1B = function(func) { return Function1B.wrap(f(func)); };

resources = resourceDao.findDomainResourcesWithLayersAndOffices(
    ru.yandex.inside.passport.blackbox.PassportDomain.YANDEX_TEAM_RU,
    SqlCondition.trueCondition(), SqlCondition.trueCondition());

resources = resources.filter((function() {
    var types = Cf.set(ResourceType.ROOM, ResourceType.YAMONEY_ROOM);
    return function(r) {
        return types.contains(r.getResource().getType()) && r.getResource().getIsActive();
    }
})());

resourceIds = resources.map(ResourceInfo.resourceIdF());

isRepeating = function(e) {
    return e.getEvent().getRecurrenceId().isDefined() || e.getEvent().getRepetitionId().isDefined()
};

isDismissed = (function() {
    var users = staffCache.getUsers();
    var dismissedUids = users.filterMap(function(u) { return Option.when(u.isDismissed(), u.getUid()) }).unique();

    return function(uid) { return dismissedUids.contains(uid.getUid()); }
})();

getEventUsers = function(e) {
    return e.getEventWithRelations().getEventUsers();
};

getParticipantEventUsers = function(e) {
    return getEventUsers(e).filter(f1B(function(eu) { return eu.getIsOrganizer() || eu.getIsAttendee() }));
};

isEventUserDismissed = function(eu) { return isDismissed(eu.getOwnerUid()); };

isEventUserGoes = function(eu) { return eu.getDecision() != Decision.NO; };

hasAliveGoingParticipant = function(e) {
    return getParticipantEventUsers(e).exists(f1B(isEventUserDismissed).notF().andF(f1B(isEventUserGoes)));
};

hasAliveGoingUser = function(e) {
    return getEventUsers(e).exists(f1B(isEventUserDismissed).notF().andF(f1B(isEventUserGoes)));
};

hasAliveParticipant = function(e) {
    return getParticipantEventUsers(e).exists(f1B(isEventUserDismissed).notF());
};

hasAliveUser = function(e) {
    return getEventUsers(e).exists(f1B(isEventUserDismissed).notF());
};

hasAliveOrganizer = function(e) {
    return getEventUsers(e).exists(f1B(function(eu) { return eu.getIsOrganizer() && !isEventUserDismissed(eu); }));
};

reprEventClosestInstance = function(e) {
    var is = RepetitionUtils.getIntervals(e.getRepetitionInstanceInfo(), Instant.now(), Option.none(), true, 1),
        start = new DateTime(is.single().getStart(), e.getEventWithRelations().getTimezone()),
        resource = e.getEventWithRelations().getResources().first();

    var url = 'https://calendar.yandex-team.ru/event'
        + '?event_id=' + e.getEvent().getId()
        + "&event_date=" + start.toDateTime(DateTimeZone.UTC).toString("YYYY-MM-dd'T'HH'%3A'mm");

    return Cf.list(e.getEvent().getName(), resource.getName().get(), resource.getOffice().getName(), start, url);
};

interval = new InstantInterval(Instant.now(), Instant.now().plus(Duration.standardDays(720)));
events = eventInfoDbLoader.getEventsOnResources(resourceIds, EventLoadLimits.intersectsInterval(interval));
events = eventInfoDbLoader.getEventInfosByEvents(
    Option.none(), events.filter(f1B(isRepeating)).map(EventAndRepetition.getEventF()), ActionSource.WEB);

print("Total actual repeating events with resources: " + events.size());
print("   with no alive organizer: " + events.count(f1B(hasAliveOrganizer).notF()));
print("   with no alive users: " + events.count(f1B(hasAliveUser).notF()));
print("   with no alive participants: " + events.count(f1B(hasAliveParticipant).notF()));
print("   with no alive going users: " + events.count(f1B(hasAliveGoingUser).notF()));
print("   with no alive going participants: " + events.count(f1B(hasAliveGoingParticipant).notF()));

print("Remove us:\n " + events
    .filter(f1B(hasAliveGoingParticipant).notF())
    .map(f(reprEventClosestInstance))
    .sortedBy(function(lst) { return lst.get(2) })
    .sortedBy(function(lst) { return lst.get(3) })
    .mkString('\n'));
