importPackage(java.lang);
importPackage(java.util);
importPackage(ru.yandex.misc.time);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.calendar.logic.resource);
importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.inside.passport.blackbox);
importPackage(ru.yandex.misc.db.q);

resources = resourceDao.findDomainResourcesWithLayersAndOffices(
        PassportDomain.YANDEX_TEAM_RU, SqlCondition.trueCondition(), SqlCondition.trueCondition());

resourceIds = resources.map(ResourceInfo.resourceIdF());
resourceIds = resourceIds.filter(Cf.set(Long(38), Long(96)).containsF().notF()); // Массажи

durationMs = function(es, interval) {
    var msF = EventAndRepetition.getInstancesInIntervalF(interval)
            .andThen(Cf.mapF(EventInstanceInterval.getIntervalF()))
            .andThen(f(function(is) {
                return is.map(InstantInterval.toDurationMillisF()).reduceLeftO(Cf.Long.plusF()).getOrElse(Long(0));
            }));
    return es.map(msF).reduceLeftO(Cf.Long.plusF()).getOrElse(Long(0));
};

printMs = function(ms) {
    var h = Long.valueOf((ms / 1000 / 60) / 60);
    var m = Long.valueOf((ms / 1000 / 60) % 60);

    return (h > 0 ? h + ' ч. ' : '') + Formatter().format('%02d мин.', m);
};

findInInterval = function(interval) {
    var events = eventInfoDbLoader.getEventsOnResources(EventGetProps.any(), resourceIds, EventLoadLimits.intersectsInterval(interval));
    var eventById = events.toMapMappingToKey(EventAndRepetition.getEventIdF());
    var eventResources = eventResourceDao.findEventResourcesByEventIdsAndResourceIds(events.map(EventAndRepetition.getEventIdF()), resourceIds);

    events = eventResources.map(EventResource.getEventIdF().andThen(eventById.asFunction()));

    var repeatingAndNot = events.partition(f1B(function(e) {
        return e.getEvent().getRecurrenceId().isDefined() || e.getEvent().getRepetitionId().isDefined()
    }));
    return Tuple2.tuple(printMs(durationMs(repeatingAndNot._1, interval)), printMs(durationMs(repeatingAndNot._2, interval)));
};

findInInterval(InstantInterval(DateMidnight(2013, 3, 15, MoscowTime.TZ), DateMidnight(2013, 6, 1, MoscowTime.TZ)));
