importPackage(java.lang);
importPackage(java.util);
importPackage(ru.yandex.misc.time);
importPackage(ru.yandex.misc.lang);
importPackage(ru.yandex.calendar.util.dates);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.calendar.logic.resource);
importPackage(ru.yandex.commune.holidays);
importPackage(ru.yandex.inside.geobase);
importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.inside.passport.blackbox);
importPackage(ru.yandex.misc.db.q);

tz = MoscowTime.TZ;
countryId = GeobaseIds.RUSSIA;

resources = resourceDao.findResources().filter(function(r) { return r.getOfficeId() == 148 && r.getIsActive() }); // 669

overlapMs = function(set1, set2) {
    return set1.overlap(set2)
        .map(function(o) { return o.getOverlap().getDuration().getMillis() })
        .reduceLeftO(Cf.Long.plusF()).getOrElse(new Long(0));
};

durationMs = function(es, interval, days) {
    var msF = function(e) {
        return overlapMs(days, new RepetitionInstanceSet(
            e.getRepetitionInfo(), interval.getStart(), interval.getEnd()));
    };
    return es.map(msF).reduceLeftO(Cf.Long.plusF()).getOrElse(new Long(0));
};

findInInterval = function(resourceId, interval, localTimeInterval) {
    var events = eventInfoDbLoader.getEventsOnResources(Cf.list(resourceId), EventLoadLimits.intersectsInterval(interval));

    var days = AuxDateTime.splitByDays(interval, tz);

    days = days.filter(function(i) {
        return !HolidayRoutines.isDayOff(new LocalDate(i.getStart(), tz), countryId, true);
    });

    if (localTimeInterval) {
        days = days.map(function(i) {
            return new InstantInterval(
                ObjectUtils.max(i.getStart().toDateTime(tz).withFields(localTimeInterval.start).toInstant(), i.getStart()),
                ObjectUtils.min(i.getStart().toDateTime(tz).withFields(localTimeInterval.end).toInstant(), i.getEnd()))
        });
    }
    days = RepetitionInstanceSet.fromSuccessiveIntervals(days);

    return new Double(new Integer(durationMs(events, interval, days)
        / overlapMs(days, RepetitionInstanceSet.single(interval)) * 10000) / 100) + '%';
};

resources = resources.sortedBy(function(r) { return r.getName().get() });

resources.map(function(resource) {
    var intervals = Cf.range(9, 12).map(function(month) {
            return new InstantInterval(
                new DateTime(2015, month, 1, 0, 0, tz),
                new DateTime(2015, month + 1, 1, 0, 0, tz))
        }),
        time = {
            start: new LocalTime(8, 0),
            end: new LocalTime(20, 0)
        };

    return Cf.list(resource.getName().get())
        .plus(intervals.map(function(interval) { return findInInterval(resource.getId(), interval, time) }))
        .mkString('\t');
}).mkString('\n');

resources.map(function(resource) {
    return Cf.list(resource.getName().get())
        .plus(Cf.range(1, 13).map(function(month) {
            var monthStart = new DateTime(2014, month, 1, 0, 0, tz);
            return findInInterval(resource.getId(), new InstantInterval(monthStart, monthStart.plusMonths(1)));
        }))
        .mkString('|');
}).mkString('\n');
