importPackage(java.lang);
importPackage(java.util);
importPackage(ru.yandex.misc.time);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.user);
importPackage(ru.yandex.calendar.logic.beans);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.calendar.util.base);

exchangeName = 'conf_st_3_dollar';
tz = DateTimeZone.forID('Europe/Moscow');
since = new LocalDate(2015, 6, 8);
till = Option.when(true, new LocalDate(2015, 8, 8));

interval = new InfiniteInterval(
    since.toDateMidnight(tz).toInstant(),
    till.map(TimeUtils.localDate.localDateTimeMidnightF().andThen(TimeUtils.localDateTime.toInstantF(tz))));

repr = function(e) {
    var organizer = e.getEventWithRelations().getParticipants().getOrganizer().getEmail(),
        firstStart = RepetitionUtils.getIntervals(e.getRepetitionInstanceInfo(), interval.getStart(), Option.none(), true, 1).single().getStart(),
        repetition = RepetitionToStringConverter.convert(e.getRepetitionInstanceInfo(), Language.RUSSIAN),
        start = (repetition.isEmpty() ? '' : 'с ') + new LocalDateTime(firstStart, tz).toString('dd/MM в HH:mm'),
        name = e.getEvent().getName();

    return Cf.list(organizer, name, start, repetition).mkString('\t');
};

events = eventInfoDbLoader.getEventInfosOnResources(
    Option.none(), EventGetProps.any(), resourceRoutines.findByExchangeName(exchangeName).map(Bean.getIdF()),
    EventLoadLimits.intersectsInterval(interval), ru.yandex.calendar.logic.event.ActionSource.WEB);

events = events.sortedBy(EventInfo.getRecurrenceIdF().andThen(Option.isEmptyF().asFunction()))
    .stableUniqueBy(EventInfo.getEventF().andThen(Event.getMainEventIdF()));

events.filter(function(e) {e.getEventWithRelations().getParticipants().getOrganizer().getLogin().isSome(String('stebenyaeva')) });

events.map(repr).mkString('\n');
