importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.event.model);
importPackage(ru.yandex.calendar.logic.resource);
importPackage(ru.yandex.calendar.logic.notification);
importPackage(ru.yandex.calendar.logic.sharing);
importPackage(ru.yandex.inside.passport);

events = deletedEventDao.getJdbcTemplate()
    .queryForList("SELECT * FROM deleted_event WHERE deletion_req_id = '19wSMPF1_2h'", DeletedEvent.class);

uid = PassportUid.cons(60598945);

actionInfo = ActionInfo.adminManager();

new org.springframework.transaction.support.TransactionTemplate(transactionManager).execute(function() {
    layerId = layerRoutines.createUserLayer(uid, Option.some('Recovered'));
    tz = dateTimeManager.getTimeZoneForUid(uid);

    events.forEach(function(e) {
        var mainId = eventRoutines.createMainEvent(e.getExternalId(), tz, actionInfo);

        var data = new EventData();
        data.getEvent().setName(e.getName());
        data.getEvent().setStartTs(e.getStartTs());
        data.getEvent().setEndTs(e.getStartTs().plus(Duration.standardMinutes(30)));
        data.setLayerId(layerId);

        eventRoutines.createUserOrFeedEvent(
            UidOrResourceId.user(uid), EventType.USER, mainId, data,
            NotificationsData.useLayerDefaultIfCreate(), InvitationProcessingMode.SAVE_ONLY, actionInfo);
    });
});
