importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.user);
importPackage(ru.yandex.calendar.util.xml);
importPackage(ru.yandex.calendar.logic.sending.real);
importPackage(ru.yandex.calendar.logic.sending.param);
importPackage(ru.yandex.calendar.logic.ics.iv5j.ical);
importPackage(ru.yandex.calendar.logic.ics.iv5j.ical.property);

e = eventDbManager.getEventWithRelationsById(804205);
mail = eventInvitationManager.createRejectMail(SpecialUsers.DBRYLEV, e, Instant.now());

decision = getField(mail, 'decision');
calendar = getField(mail, 'calendar');
common = getField(mail, 'commonMessageParameters');
info = getField(mail, 'eventMessageInfo');

event = calendar.getEvents().single();
event = event.addProperty(IcsStatus('CONFIRMED', Cf.list()));
event = event.addProperty(IcsComment('No op to attend'));

calendar = IcsCalendar(calendar.getTimezones().plus1(event), calendar.getProperties());

mail = ReplyMessageParameters(common, info, decision, calendar);

doc = XslUtils.applyXslt(mail.toOldStyleXml(), mail.mailType().getXslName().getSS());
mes = MessageXml.parseMessage(doc);

mes = MailHacks.addCalendarHeaders(mes, mail.mailType(), ActionSource.WEB);
mes = mes.withHeader('Reply-To', mes.getHeader('From').get()).withHeader('From', '"Calendar BOT" <info@calendar.yandex-team.ru>');

smailik.sendMails(Cf.list(mes));
