importPackage(ru.yandex.calendar.logic.contact);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.ics.exp);
importPackage(ru.yandex.calendar.logic.sending);
importPackage(ru.yandex.calendar.logic.sharing);
importPackage(ru.yandex.calendar.logic.sharing.participant);
importPackage(ru.yandex.commune.mail);
importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.misc.email);
importPackage(ru.yandex.misc.time);

invoke = function(obj, name, varargs) {
    return ru.yandex.misc.reflection.MethodX.getSingleMethod(obj.getClass(), name)
        .setAccessibleTrueReturnThis()
        .invoke(obj, Array.prototype.slice.call(arguments, 2));
};

send = function(email, eventId, singleOccurrence) {
    email = new Email(email);
    eventId = new java.lang.Long(eventId);

    var uid = userManager.getUidByEmail(email).getOrThrow("not yandex user");
    var user = userManager.getYtUserByEmail(email).getOrThrow("not staff user");
    var event = eventDbManager.getEventWithRelationsById(eventId);
    var sendingInfo;

    if (event.getParticipants().isParticipantWithInconsistent(uid)) {
        sendingInfo = new EventSendingInfo(
            event.getParticipants().getParticipantByUid(uid).get(),
            MailType.EVENT_INVITATION, EventInstanceParameters.fromEvent(event.getEvent()), Option.none());
    } else {
        sendingInfo = new EventSendingInfo(
            new UnivContact(user), Option.none(), eventId,
            MailType.EVENT_INVITATION, EventInstanceParameters.fromEvent(event.getEvent()), Decision.UNDECIDED);
    }

    if (singleOccurrence) {
        var sender = eventInvitationManager.getSender(ActorId.yaCalendar());
        return eventInvitationManager.sendEventMails(Cf.list(invoke(
            eventInvitationManager, 'createInvitationOrCancelMailXmlForEvent',
            sender, eventInfoDbLoader.getEventInfosByIds(Option.none(), Cf.list(eventId), ActionSource.PERFORMER),
            sendingInfo, Instant.now())), ActionInfo.adminManager());

    } else {
        return eventInvitationManager.createAndSendEventInvitationOrCancelMails(
            ActorId.yaCalendar(), Cf.list(sendingInfo), ActionInfo.adminManager());
    }
};

sendExternal = function(email, eventId, singleOccurrence) {
    eventId = new java.lang.Long(eventId);

    var event = eventDbManager.getEventWithRelationsById(eventId);

    var sendingInfo = new EventSendingInfo(
        new UnivContact(new MailAddress(new Email(email), null)), Option.none(), eventId,
        MailType.EVENT_INVITATION, EventInstanceParameters.fromEvent(event.getEvent()), Decision.UNDECIDED);

    if (singleOccurrence) {
        var sender = eventInvitationManager.getSender(ActorId.yaCalendar());
        return eventInvitationManager.sendEventMails(Cf.list(invoke(
            eventInvitationManager, 'createInvitationOrCancelMailXmlForEvent',
            sender, eventInfoDbLoader.getEventInfosByIds(Option.none(), Cf.list(eventId), ActionSource.PERFORMER),
            sendingInfo, Instant.now())), ActionInfo.adminManager());
    } else {
        return eventInvitationManager.createAndSendEventInvitationOrCancelMails(
            ActorId.yaCalendar(), Cf.list(sendingInfo), ActionInfo.adminManager());
    }
};
