importPackage(ru.yandex.bolts.collection);
importPackage(ru.yandex.misc.email);
importPackage(ru.yandex.misc.time);
importPackage(org.joda.time);
importPackage(ru.yandex.calendar.logic.resource);

sync = function(email, daysFromNow) {
    email = new Email(email);

    var now = Instant.now();

    var interval = new InstantInterval(now, now.plus(Duration.standardDays(daysFromNow)));

    var externalIds = ewsComparator.compare(email, interval)
        .getCalendarUniqueKeysDecided()
        .filterMap(function(key) {
            return getField(key, 'externalIdO')
        }).unique();

    var uid = userManager.getUidByEmail(email).get();

    var subsctiptions = Cf.list(uid).zipWith(function (uid) {return ytEwsSubscriptionDao.findUserSubscription(uid)});

    var no_subscription = subsctiptions.filterBy2(function (sO) {return sO.isEmpty()}).get1();

    no_subscription.forEach(function (uid) {
        exchangeSubscriber.subscribeUser(uid);
        exchangeSubscriber.subscribeUserToPull(uid);
    });

    var user = UidOrResourceId.user(uid);

    var eventIds = externalIds.filterMap(function(externalId) {
        return eventRoutines.findMasterEventBySubjectIdAndExternalId(user, externalId);
    }).map(function(event) {return event.getId();});

    //requires 'send invitation.js'
    eventIds.map(function(eventId) {
        send(email.toString(), eventId, false);
    });
};
