importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.misc.db.resultSet);
importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.misc.db.resultSet);
importPackage(ru.yandex.misc.reflection);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.event.model);
importPackage(ru.yandex.calendar.logic.sharing);
importPackage(ru.yandex.misc.time);
importPackage(ru.yandex.calendar.logic.user);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.calendar.logic.resource);
importPackage(ru.yandex.calendar.util.base);
importPackage(ru.yandex.calendar.logic.event.avail);
importPackage(ru.yandex.commune.mail);
importPackage(ru.yandex.calendar.logic.sending.real);

searchStart = MoscowTime.instant(2014, 10, 28, 0, 0);
searchEnd = MoscowTime.instant(2015, 4, 1, 0, 0);
createdBefore = MoscowTime.instant(2014, 10, 17, 0, 0);

mainEventIds = notificationDao.getJdbcTemplate().queryForList(
    "SELECT DISTINCT me.id FROM main_event me" +
    " INNER JOIN event e ON e.main_event_id = me.id" +
    " INNER JOIN event_resource er ON er.event_id = e.id" +
    " INNER JOIN resource res ON res.id = er.resource_id" +
    " INNER JOIN office o ON o.id = res.office_id" +
    " LEFT JOIN repetition r ON r.id = e.repetition_id" +
    " WHERE (e.end_ts > '2014-10-28' OR (r.id IS NOT NULL AND r.due_ts IS NULL OR r.due_ts > '2014-10-28'))" +
    " AND (me.timezone_id IN ('Europe/Moscow', 'Europe/Simferopol'," +
    " 'Asia/Magadan', 'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Sakhalin', 'Asia/Vladivostok'," +
    " 'Asia/Yakutsk', 'Asia/Yekaterinburg', 'Europe/Kaliningrad', 'Europe/Volgograd')" +
    " = o.timezone_id NOT IN ('Europe/Moscow', 'Europe/Simferopol'," +
    " 'Asia/Magadan', 'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Sakhalin', 'Asia/Vladivostok'," +
    " 'Asia/Yakutsk', 'Asia/Yekaterinburg', 'Europe/Kaliningrad', 'Europe/Volgograd'));", java.lang.Long);

mainEventInfos = eventInfoDbLoader.getMainEventInfos(Option.none(), mainEventDao.findMainEventsByIds(mainEventIds), ActionSource.WEB);

masterEventInfos = mainEventInfos.flatMap(f(function(me) { return me.getEventInfos() }));

masterEventInfos = masterEventInfos.filter(f1B(function(e) {
    return e.getEvent().getCreationTs().isBefore(createdBefore)
        && RepetitionUtils.findInstanceIntervalOverlappingInterval(
            e.getRepetitionInstanceInfo(),
            new InstantInterval(searchStart, searchEnd)).isDefined();}));

byOrganizer = masterEventInfos.groupBy(f(function(e) { return e.getEventWithRelations().getParticipants().getOrganizer().getEmail() }));

dateBeforeTransition = new LocalDate(2014, 10, 1);
dateAfterTransition = new LocalDate(2014, 11, 1);

transitionTzs = Cf.list(
    'Europe/Moscow', 'Europe/Simferopol', 'Asia/Magadan',
    'Asia/Novosibirsk', 'Asia/Omsk', 'Asia/Sakhalin',
    'Asia/Vladivostok', 'Asia/Yakutsk', 'Asia/Yekaterinburg',
    'Europe/Kaliningrad', 'Europe/Volgograd').map(f(function(id) { return DateTimeZone.forID(id) }));

bind = function(f, ctx, args) {
    args = Array.prototype.slice.call(arguments, 2);

    return function() {
        return f.apply(ctx, args.concat(Array.prototype.slice.call(arguments, 0)));
    }
};

outStackTrace = function(f) {
    try {
        f();
    } catch (e) {
        e.rhinoException && e.rhinoException.printStackTrace(out);
        throw e;
    }
};

invokeStatic = function(clazz, name, varargs) {
    return ru.yandex.misc.reflection.MethodX.getSingleMethod(clazz, name)
        .setAccessibleTrueReturnThis()
        .invokeStatic(Array.prototype.slice.call(arguments, 2));
};

reprEvent = function(e) {
    var title = "«" + e.getEvent().getName() + "» " + (e.getRepetitionInstanceInfo().isEmpty()
        ? new LocalDate(e.getEvent().getStartTs(), e.getTimezone()).toString('dd MMMM', java.util.Locale("ru"))
        : RepetitionToStringConverter.convert(e.getRepetitionInstanceInfo(), Language.RUSSIAN));

    if (e.getEvent().getStartTs().isAfter(searchStart)
        && !e.getRepetitionInstanceInfo().isEmpty()
        && e.getRepetitionInstanceInfo().getRepetition().get().getDueTs().isEmpty())
    {
        title += " с " + new LocalDate(e.getEvent().getStartTs(), e.getTimezone()).toString('dd MMMM', java.util.Locale("ru"));
    }

    title += " (" + e.getTimezone() + ")";

    var intervalAfterTransition = RepetitionUtils.getInstanceIntervalStartingAfter(
        e.getRepetitionInstanceInfo(), searchStart);

    if (!intervalAfterTransition.isDefined()) return "";

    var instantAfterTransition = intervalAfterTransition.get().getStart();

    var before = e.getEventWithRelations().getResources().map(f(function(r) {
        var officeTz = DateTimeZone.forID(r.getOffice().getTimezoneId().get()),
            instant = instantAfterTransition;

        if (transitionTzs.contains(e.getTimezone()) && !transitionTzs.contains(officeTz)) {
            instant = instantAfterTransition.minus(Duration.standardHours(1));
        }
        if (!transitionTzs.contains(e.getTimezone()) && transitionTzs.contains(officeTz)) {
            instant = instantAfterTransition.plus(Duration.standardHours(1));
        }

        return Cf.list(r.getName().get(),
            new LocalDateTime(instant, officeTz).toLocalTime().toString("HH:mm"),
            r.getOffice().getCityName().get()).mkString(", ");
    })).mkString(" - ");

    var after = e.getEventWithRelations().getResources().map(f(function(r) {
        var officeTz = DateTimeZone.forID(r.getOffice().getTimezoneId().get());

        return Cf.list(r.getName().get(),
            new LocalDateTime(instantAfterTransition, officeTz).toLocalTime().toString("HH:mm"),
            r.getOffice().getCityName().get()).mkString(", ");
    })).mkString(" - ");

    var resourceById = e.getEventWithRelations().getResources().toMapMappingToKey(ResourceInfo.resourceIdF());

    var request = AvailabilityRequest.intervals(new RepetitionInstanceSet(
        e.getRepetitionInstanceInfo(), searchStart, searchEnd));

    request = request.excludeEventId(Option.some(java.lang.Long(e.getEventId())));
    request = request.includeEventsNames();

    var availabilities = availRoutines.getAvailabilityIntervalss(TestUsers.DBRYLEV,
        e.getEventWithRelations().getResourceIds().map(UidOrResourceId.resourceF()),
        request, ActionInfo.adminManager());

    var conflicts = availabilities.flatMap(f(function(avails) {
        var resource = resourceById.apply(java.lang.Long(avails.getSubjectId().getResourceId())),
            officeTz = DateTimeZone.forID(resource.getOffice().getTimezoneId().get());

        var unique = Cf2.stableUniqueBy(avails.getIntervalsO().get().unmerged(), f(function(a) { return a.getEventId().get(); }));

        return unique.map(f(function(avail) {
            return Cf.list("«" + avail.getEventName().get() + "»", resource.getName().get(),
                new LocalDateTime(avail.getInterval().getStart(), officeTz).toString("d MMMM 'в' HH:mm", java.util.Locale("ru")),
                resource.getOffice().getCityName().get()).mkString(", ");
        }));
    }));

    var repr = title + "<br/>Было: " + before + "<br/>Стало: " + after;

    if (conflicts.isNotEmpty()) {
        repr += "<br/><br/>Наложилась на встречи:<br/>" + conflicts.mkString('<br/>');
    }

    var eventEditLink = "https://calendar.yandex-team.ru/event?event_id=" + e.getEventId();

    if (!e.getRepetitionInstanceInfo().isEmpty()) {
        eventEditLink += "&event_date=" + new LocalDateTime(instantAfterTransition, e.getEventWithRelations().getParticipants().getOrganizer().getSettings().getTz()).toString("YYYY-MM-dd'T'HH:mm:ss");
    }

    return repr + "<br/><br/>" + "<a href=\"" + eventEditLink +"\">Редактировать</a><br/><br/>";
};

createHtml = function(eventInfos) {
    var html = "<html><body>";

    html += "<p>В связи с переходом на зимнее время в России, встречи, которые были созданы в переговорках офисов в двух или более городов, сдвинулись на час." +
        "<br>Приносим свои извинения за доставленные неудобства.</p>";
    html += "<p>Просим обратить внимание на созданные ранее встречи и выбрать при необходимости для них новое время и переговорку.</p>";

    html += "Изменилось:<br/>";

    if (eventInfos.size() != 1) {
        html += "<ol type=\"1\">";
        html += eventInfos.map(f(function(e) { return "<li>" + reprEvent(e) + "</li>" } )).mkString('\n');
        html += "</ol>";
    } else {
        html += "<p style=\"padding-left: 40px\">" + reprEvent(eventInfos.single()) + "</p>";
    }

    html += "<p>Еще раз приносим свои извинения.</p>";

    html += "</body></html>";

    return html;
};

prepareMessage = function(email, eventInfos) {
    var mailMessage = MailMessage.empty();

    mailMessage = mailMessage.withFrom(new MailAddress(Email("noreply@yandex-team.ru"), "Яндекс.Календарь"));
    mailMessage = mailMessage.withTo(email);
    mailMessage = mailMessage.withSubject("Изменилось время встречи");

    mailMessage = mailMessage.withDate(Instant.now());
    mailMessage = mailMessage.withMessageId();

    mailMessage = invokeStatic(MailHacks, "addYacalHeader", mailMessage);
    mailMessage = mailMessage.addPart(BodyPart.create(new DefaultContent(createHtml(eventInfos)), ContentType.TEXT_HTML_UTF8));

    return mailMessage;
};

sendMessage = function(email, eventInfos) {
    return getField(mailSender, 'smailik').sendMails(Cf.list(prepareMessage(email, eventInfos)));
};

outStackTrace(function() { return reprEvent(masterEventInfos.get(2)) });

reprEvent(masterEventInfos.find(f1B(function(e) { return e.getEventWithRelations().getTimezone().equals(MoscowTime.TZ)})).get())
