dateAfterTransition = new LocalDate(2016, 10, 31);
oldTzPrefix = 'tz2016f/';

Tz = DateTimeZone;
tsAfterTransition = dateAfterTransition.toDateTimeAtStartOfDay(Tz.UTC).getMillis();

tzIds = Cf.x(Tz.getAvailableIDs())
    .filter(function(tz) {
        return !tz.startsWith(oldTzPrefix)
            && Tz.getAvailableIDs().contains(oldTzPrefix + tz)
            && Tz.forID(tz).getOffset(tsAfterTransition) != Tz.forID(oldTzPrefix + tz).getOffset(tsAfterTransition);
    })
    .sorted();

// SELECT distinct(timezone_id) FROM main_event WHERE timezone_id IN tzIds.map(function(tz) { return "'" + tz + "'"}).mkString(',');
tzIds = Cf.list('Africa/Cairo', 'Asia/Sakhalin', 'Asia/Pyongyang', 'Asia/Baku', 'Asia/Chita', 'Asia/Hovd', 'Asia/Ulaanbaatar');

function generateTransitionSql(tzId) {
    var oldTz = Tz.forID(oldTzPrefix + tzId),
        newTz = Tz.forID(tzId),
        toOffset = dateAfterTransition.toDateTimeAtStartOfDay(newTz).toString('ZZ'),
        fromOffset = dateAfterTransition.toDateTimeAtStartOfDay(oldTz).toString('ZZ'),
        transitionDateTime = Cf.list(
            new LocalDateTime(newTz.previousTransition(tsAfterTransition) + 1, Tz.UTC),
            new LocalDateTime(oldTz.previousTransition(tsAfterTransition) + 1, Tz.UTC)).max();

    function columnValueMatch(name) {
        return name + " >= '" + transitionDateTime.toString('YYYY-MM-dd HH:mm:ss') + "'";
    }

    function indentDueTsValueMatch(name) {
        return columnValueMatch(name) + " AND " + name + " != '2100-01-01 00:00:00'"
    }

    function convertColumnValue(name) {
        return name + " AT TIME ZONE '" + fromOffset + "' AT TIME ZONE '" + toOffset + "'";
    }

    function assignConvertedIfColumnValueMatch(name, table, match) {
        var prefixed = (table ? table + "." : "") + name;
        return name + " = (CASE WHEN " + (match || columnValueMatch)(prefixed)
            + " THEN " + convertColumnValue(prefixed)
            + " ELSE " + prefixed + " END)";
    }

    function assignConvertedIfIndentDueTsValueMatch(table) {
        return assignConvertedIfColumnValueMatch("repetition_due_ts", table, indentDueTsValueMatch);
    }

    function setConvertedColumnValue(name) {
        return "SET " + name + " = " + convertColumnValue(name);
    }

    function whereTzAndColumnValuesMatch(names, customFieldMatch) {
        return "WHERE me.timezone_id = '" + tzId + "'"
            + "\n    AND ("
            + names.map(columnValueMatch).plus(customFieldMatch || Cf.list()).mkString(' OR ') + ')';
    }

    function setColumnsIfValuesMatch(names, table) {
        return "SET " + names.map(function(n) { return assignConvertedIfColumnValueMatch(n, table) }).mkString(',\n    ');
    }

    var whereHasOccurrencesAfterTransition = whereTzAndColumnValuesMatch(
        Cf.list('e.end_ts', 'r.due_ts'), Cf.list('r.id IS NOT NULL AND r.due_ts IS NULL'));

    return Cf.list(
        '-- ' + tzId,

        'UPDATE event e' + '\n'
            + setColumnsIfValuesMatch(Cf.list('start_ts', 'end_ts', 'recurrence_id'), "e") + '\n'
            + 'FROM main_event me' + '\n'
            + whereTzAndColumnValuesMatch(Cf.list('e.start_ts', 'e.end_ts', 'e.recurrence_id')) + '\n'
            + '    AND me.id = e.main_event_id',

        'UPDATE event_notification en' + '\n'
            + setConvertedColumnValue("next_send_ts") + '\n'
            + 'FROM event_user eu' + '\n'
            + 'INNER JOIN event e ON e.id = eu.event_id' + '\n'
            + 'INNER JOIN main_event me ON me.id = e.main_event_id' + '\n'
            + whereTzAndColumnValuesMatch(Cf.list("en.next_send_ts")) + '\n'
            + '    AND eu.id = en.event_user_id',

        'UPDATE rdate r' + '\n'
            + setColumnsIfValuesMatch(Cf.list('start_ts', 'end_ts'), "r") + '\n'
            + 'FROM event e' + '\n'
            + 'INNER JOIN main_event me ON me.id = e.main_event_id' + '\n'
            + whereTzAndColumnValuesMatch(Cf.list('r.start_ts', 'r.end_ts')) + '\n'
            + '    AND e.id = r.event_id',

        'UPDATE repetition r' + '\n'
            + setColumnsIfValuesMatch(Cf.list('due_ts'), "r") + '\n'
            + 'FROM event e' + '\n'
            + 'INNER JOIN main_event me ON me.id = e.main_event_id' + '\n'
            + whereTzAndColumnValuesMatch(Cf.list('r.due_ts')) + '\n'
            + '    AND e.repetition_id = r.id',

        'UPDATE event_layer el' + '\n'
            + setColumnsIfValuesMatch(Cf.list('event_start_ts', 'event_end_ts'), 'el') + ',\n'
            + '    ' + assignConvertedIfIndentDueTsValueMatch('el') + '\n'
            + 'FROM event e' + '\n'
            + 'INNER JOIN main_event me ON me.id = e.main_event_id' + '\n'
            + whereTzAndColumnValuesMatch(
                Cf.list('el.event_start_ts', 'el.event_end_ts'),
                Cf.list(indentDueTsValueMatch('el.repetition_due_ts'))) + '\n'
            + '    AND e.id = el.event_id',

        'UPDATE event_resource er' + '\n'
            + setColumnsIfValuesMatch(Cf.list('event_start_ts', 'event_end_ts'), 'er') + ',\n'
            + '    ' + assignConvertedIfIndentDueTsValueMatch('er') +'\n'
            + 'FROM event e' + '\n'
            + 'INNER JOIN main_event me ON me.id = e.main_event_id' + '\n'
            + whereTzAndColumnValuesMatch(
                Cf.list('er.event_start_ts', 'er.event_end_ts'),
                Cf.list(indentDueTsValueMatch('er.repetition_due_ts'))) + '\n'
            + '    AND e.id = er.event_id',

        'UPDATE main_event me' + '\n'
            + 'SET last_update_ts = NOW() AT TIME ZONE \'UTC\'' + '\n'
            + 'FROM event e' + '\n'
            + 'LEFT JOIN repetition r ON r.id = e.repetition_id' + '\n'
            + whereHasOccurrencesAfterTransition + '\n'
            + '    AND e.main_event_id = me.id',

        'UPDATE layer l' + '\n'
            + 'SET coll_last_update_ts = NOW() AT TIME ZONE \'UTC\'' + '\n'
            + 'FROM event_layer el' + '\n'
            + 'INNER JOIN event e ON e.id = el.event_id' + '\n'
            + 'INNER JOIN main_event me ON me.id = e.main_event_id' + '\n'
            + 'LEFT JOIN repetition r ON r.id = e.repetition_id' + '\n'
            + whereHasOccurrencesAfterTransition + '\n'
            + '    AND el.layer_id = l.id'

    ).mkString('', ';\n\n', ';');
}

tzIds.map(generateTransitionSql).plus1('DELETE FROM resource_schedule;').mkString('\n\n');
