importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.misc.db.resultSet);
importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.misc.db.resultSet);
importPackage(ru.yandex.misc.reflection);

callback = function(func) {
    return new org.springframework.jdbc.core.RowCallbackHandler() {
        processRow: function x() {
            return func.apply(this, arguments);
        }
    }
};

recalc = ClassX.wrap(notificationRoutines.getClass()).getDeclaredMethods('recalcNextSendTs').get(1).setAccessibleTrueReturnThis();
update = ClassX.wrap(genericBeanDao.getClass()).getDeclaredMethods('executeBatch').single().setAccessibleTrueReturnThis();

handler = function(list) {
    var tzByUid = dateTimeManager.getTimeZonesForUids(list.map(Tuple3.get2F().andThen(EventUser.getOwnerUidF()))).toMap(),
        repetitionByEventId = repetitionRoutines.getRepetitionInstanceInfosByEvents(list.map(Tuple3.get3F()));

    var recalculated = Cf.arrayList();

    list.map(f(function(tuple) {
        var en = tuple.get1(), eu = tuple.get2(), e = tuple.get3();

        var nextSend = recalc.invokeStatic(en, e,
            repetitionByEventId.apply(java.lang.Long(eu.getEventId())),
            tzByUid.apply(eu.getOwnerUid()), en.getNextSendTs().get());

        if (nextSend.isDefined() && Duration(en.getNextSendTs().get(), nextSend.get()).isEqual(Duration.standardHours(1))) {
            recalculated.add(en);
        }
    }));

    update.invoke(genericBeanDao, recalculated,
        Cf.list(EventNotificationFields.ID, EventNotificationFields.NEXT_SEND_TS),
        EventNotificationHelper.INSTANCE.beanMapObjectDescription(),
        'UPDATE event_notification SET next_send_ts = DATE_ADD(next_send_ts, INTERVAL 1 HOUR) WHERE id = ? AND next_send_ts = ?', false);
};

q = 'SELECT en.*, eu.*, e.*' +
    ' FROM event_notification en INNER JOIN event_user eu ON eu.id = en.event_user_id' +
    ' INNER JOIN event e ON e.id = eu.event_id' +
    ' WHERE en.next_send_ts IS NOT NULL AND e.repetition_id IS NOT NULL';

rm = Tuple3RowMapper.rowMapper(
    EventNotificationHelper.INSTANCE.beanRowMapper('en.'),
    EventUserHelper.INSTANCE.beanRowMapper('eu.'),
    EventHelper.INSTANCE.beanRowMapper('e.'));

rows = Cf.arrayList(200);

notificationDao.getJdbcTemplate().queryStream(q, callback(function(rs) {
    rows.add(rm.mapRow(rs, 1));

    if (rows.size() >= 200) {
        handler(rows);
        rows.clear();
    }
}));

if (rows.isNotEmpty()) {
    handler(rows);
}
