importPackage(java.lang);
importPackage(java.util);
importPackage(ru.yandex.misc.time);
importPackage(ru.yandex.calendar.logic.event);
importPackage(ru.yandex.calendar.logic.beans.generated);
importPackage(ru.yandex.calendar.logic.event.repetition);
importPackage(ru.yandex.calendar.logic.resource);
importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.inside.passport.blackbox);
importPackage(ru.yandex.misc.db.q);

exchangeNames = Cf.list('conf_st_3_hryvnia', 'conf_st_3_dollar', 'conf_st_3_euro', 'conf_st_3_ruble', 'conf_st_3_tenge')
    .map(f(function(v) { return java.lang.String(v) }));

resources = resourceDao.findResourceInfosByExchangeNames(exchangeNames);
resourceIds = resources.map(ResourceInfo.resourceIdF());

durationMs = function(es, interval) {
    var msF = EventAndRepetition.getInstancesInIntervalF(interval)
        .andThen(Cf.mapF(EventInstanceInterval.getIntervalF()))
        .andThen(f(function(is) {
            return is.map(InstantInterval.toDurationMillisF()).reduceLeftO(Cf.Long.plusF()).getOrElse(Long(0));
        }));
    return es.map(msF).reduceLeftO(Cf.Long.plusF()).getOrElse(Long(0));
};

printMs = function(ms) {
    var h = Long.valueOf((ms / 1000 / 60) / 60);
    var m = Long.valueOf((ms / 1000 / 60) % 60);

    return (h > 0 ? h + ' ч. ' : '') + Formatter().format('%02d мин.', m);
};

findInInterval = function(interval) {
    var events = eventInfoDbLoader.getEventsOnResources(EventGetProps.any(), resourceIds, EventLoadLimits.intersectsInterval(interval));
    var eventIds = events.map(EventAndRepetition.getEventIdF());
    var eventById = events.toMapMappingToKey(EventAndRepetition.getEventIdF());
    var organizerByEventId = eventInvitationManager.findOrganizersByEventIds(eventIds).toMap();
    var eventResources = eventResourceDao.findEventResourcesByEventIdsAndResourceIds(eventIds, resourceIds);

    events = eventResources.map(EventResource.getEventIdF().andThen(eventById.asFunction()));

    var yamoneyAndNot = events.partition(f1B(function(e) {
        var organizer = organizerByEventId.getOrThrow(java.lang.Long(e.getEventId()), 'no organizer for ' + e.getEventId()).getOrThrow('no organizer for ' + e.getEventId());
        var organizerUid = organizer.getUidIfYandexUser().getOrThrow('not user organized for ' + e.getEventId());
        var organizerUser = userManager.getYtUserByUid(organizerUid).getOrThrow('organizer not found in center for ' + e.getEventId());

        return organizerUser.getDepartment().getUrl().startsWith(java.lang.String('yandex_money'));
    }));
    return Tuple2.tuple(printMs(durationMs(yamoneyAndNot._1, interval)), printMs(durationMs(yamoneyAndNot._2, interval)));
};

findInInterval(InstantInterval(DateMidnight(2014, 11, 3, MoscowTime.TZ), DateMidnight(2014, 12, 4, MoscowTime.TZ)));
