import os


def is_arcadia():
    try:
        import __res
        assert __res
        return True
    except ImportError:
        pass
    import sys
    return hasattr(sys, "extra_modules")


def read_file_or_resource(filename):
    if is_arcadia():
        from library.python import resource
        filename = 'resfs/file/' + filename
        queries_file = resource.find(filename)
        if not queries_file:
            raise RuntimeError('Resource %r do not exists' % filename)
        return queries_file
    else:
        if not os.path.exists(filename):
            raise RuntimeError('File at path %r do not exists' % filename)
        with open(filename) as fd:
            return fd.read()
