import asyncio


class StatefulEvent(asyncio.Event):
    def __init__(self, **kwargs):
        super(StatefulEvent, self).__init__(**kwargs)
        self._state = None
        self._exc: Exception = None

    def set(self, state=None):
        self._state = state
        super(StatefulEvent, self).set()

    def set_exception(self, exc: Exception):
        self._exc = exc

    async def wait(self):
        await super(StatefulEvent, self).wait()
        if self._exc:
            raise self._exc
        return self._state
