class BadRequest(RuntimeError):
    def __init__(self, *args, fail_status: str = 'fail', fail_data=None, **kwargs):
        self.fail_status = fail_status
        self.fail_data = fail_data
        super(BadRequest, self).__init__(*args, **kwargs)


class EntityDoesNotExist(BadRequest):
    pass


class InvalidEntityCondition(BadRequest):
    pass


class InvalidEntityData(BadRequest):
    pass


class EntityAlreadyExists(InvalidEntityData):
    pass


class TooManyRequests(BadRequest):
    pass
