# coding=utf-8

import ujson as json
from typing import Dict

from aiohttp import web

HTTP_200 = 200
HTTP_400 = 400
HTTP_500 = 500
HTTP_501 = 501

dumps = json.dumps
loads = json.loads


def success(data: Dict) -> web.Response:
    code = HTTP_200
    body = {
        'code': code,
        'status': "success",
        'data': data,
    }
    return web.json_response(body, status=code, dumps=dumps)


def fail(message: str, status: str = 'fail', data: Dict = None) -> web.Response:
    code = HTTP_400
    body = {
        'code': code,
        'status': status,
        'message': message,
    }
    if data is not None:
        body['data'] = data
    return web.json_response(body, status=code, dumps=dumps)


def error(message: str) -> web.Response:
    return temp_error(HTTP_500, message)


def not_implemented() -> web.Response:
    return temp_error(HTTP_501, 'Not yet implemented')


def temp_error(code: int, message: str) -> web.Response:
    body = {
        'code': code,
        'status': "error",
        'message': message,
    }
    return web.json_response(body, status=code, dumps=dumps)
