import logging

from datetime import datetime, timezone
from yarl import URL

from mail.callmeback.callmeback.detail.retry_params import RetryParams
from mail.callmeback.callmeback.detail.errors import InvalidEntityData

log = logging.getLogger(__name__)


def parse_datetime(dt_str: str, field_name: str) -> datetime:
    DT_FORMATS = ['%Y-%m-%dT%H:%M:%SZ', '%Y-%m-%dT%H:%M:%S.%fZ']
    for dt_format in DT_FORMATS:
        try:
            return datetime.strptime(dt_str, dt_format).replace(tzinfo=timezone.utc)
        except ValueError:
            pass
    raise InvalidEntityData(f'Invalid {field_name} format, should be one of: {DT_FORMATS}')


def check_context(context: dict):
    retry_params = context.get('retry_params', {})
    try:
        RetryParams.check_params(retry_params)
    except Exception:
        log.exception('Invalid retry_params')
        raise InvalidEntityData(f'Invalid retry_params: {retry_params}')


def validated_url(url: str, field_name: str) -> str:
    try:
        parsed = URL(url)
        if not parsed.scheme:
            raise Exception('empty scheme')
        if not parsed.host:
            raise Exception('empty host')
        return url
    except Exception as e:
        log.exception(f'Invalid {field_name}')
        raise InvalidEntityData(f'Invalid {field_name}="{url}": {str(e)}')
