from os import environ

from mail.python.theatre.app.settings.db import DbSettings as DbSettingsBase
from mail.python.theatre.app.settings.db import MultihostDbSettings as MHDBSettingsBase


class DbSettings(DbSettingsBase):
    def prod(self):
        self.name = 'callmebackdb_prod'
        self.user = 'callmeback'
        self.host = 'c-6a12b272-08ce-417d-a208-5ceac6293ba6.rw.db.yandex.net'
        self.host_ro = 'c-6a12b272-08ce-417d-a208-5ceac6293ba6.ro.db.yandex.net'
        self.port = 6432

    def test(self):
        self.name = 'callmebackdb_test'
        self.user = 'callmeback'
        self.host = 'c-482d6b0a-a096-4692-b5c8-4af1680064d2.rw.db.yandex.net'
        self.host_ro = 'c-482d6b0a-a096-4692-b5c8-4af1680064d2.ro.db.yandex.net'
        self.port = 6432

    def local(self):
        self.name = 'callmebackdb'
        self.user = 'callmeback'
        self.password = 'Passw0rd'
        self.host = self.host_ro = 'localhost'
        self.port = 5552
        self.ssl = False

    def devpack(self):
        self.local()
        self.password = None
        self.port = environ['CALLMEBACKDB_PORT']

    def docker(self):
        self.local()
        self.host = self.host_ro = 'db'
        self.port = 12000


class MultihostDbSettings(DbSettings, MHDBSettingsBase):
    def prod(self):
        super().prod()
        self.port = 6432
        self.hosts = {
            'vla': 'vla-g7weqw3uz2k2epr5.db.yandex.net',
            'myt': 'myt-x1no6echpinw0fab.db.yandex.net',
            'sas': 'sas-zx1fvpm0cmd66zc6.db.yandex.net',
        }

    def test(self):
        super().test()
        self.port = 6432
        self.hosts = {
            'vla': 'vla-93scdrf9uh97xve5.db.yandex.net',
            'sas': 'sas-zrrj45bjdwo4ejlu.db.yandex.net',
        }

    def local(self):
        super().local()
        self.hosts = {'local': self.host}

    def devpack(self):
        super().devpack()
        self.hosts = {'devpack': self.host}
