from yarl import URL

from mail.callmeback.callmeback.stages.api.settings import WorkerMonitorSettings
from mail.python.theatre.roles import Cron
from mail.python.theatre.app.roles.db_multihost_pool import DbMultihostPool


class ActiveWorkerMonitor(Cron):
    """Retrieves current active workers and their respective bucket ids from DB"""
    def __init__(self, pool: DbMultihostPool, settings: WorkerMonitorSettings):
        super(ActiveWorkerMonitor, self).__init__(job=self._job, **settings.cron.as_dict())
        self._pool = pool
        self._bucket2worker = {}

    @property
    def bucket2worker(self):
        return self._bucket2worker

    async def _job(self):
        async with self._pool(ro=True).acquire(timeout=2) as conn:
            records = await conn.fetch('''
                -- watch_buckets
                SELECT bucket_id, hostname
                  FROM reminders.buckets
            ''')
        self._bucket2worker = {r['bucket_id']: r['hostname'] and URL(r['hostname'], encoded=True) for r in records}
