import datetime
import logging
from typing import List

from mail.callmeback.callmeback.stages.api.props.notify_item import NotifyItem
from mail.callmeback.callmeback.stages.api.settings.worker_notifier import WorkerNotifierSettings
from mail.python.theatre.roles import HttpPooled, Queued
from .worker_monitor import ActiveWorkerMonitor

log = logging.getLogger(__name__)


class WorkerNotifier(HttpPooled, Queued):
    """Makes workers aware of new events, optimizing latency and DB querying on workers"""
    def __init__(self, workers_monitor: ActiveWorkerMonitor, settings: WorkerNotifierSettings):
        super(WorkerNotifier, self).__init__(
            job=self._job,
            **settings.http_pool.as_dict(),
            **settings.servant.as_dict()
        )
        self._workers_mon = workers_monitor

    async def _job(self, data: List[NotifyItem]):
        run_ats = {}
        for item in data:
            url = self._workers_mon.bucket2worker.get(item.bucket_id)
            if url is not None:
                run_ats[url] = min(run_ats.setdefault(url, item.run_at), item.run_at)
        for url, run_at in run_ats.items():
            await self._notify(url, run_at)

    async def _notify(self, url, run_at: datetime.datetime):
        async with self.http_session.get(
            url=url,
            params={'at': str(run_at.timestamp())},
        ) as resp:
            log.debug(resp)
