import logging

from aiohttp import web

from mail.callmeback.callmeback.detail.validation import parse_datetime, check_context, validated_url
from mail.callmeback.callmeback.detail.http_helpers import jsend
from mail.callmeback.callmeback.detail.http_helpers.tvm import TvmServiceTickets
from .event_buffer import EventBuffer
from .notify_item import NotifyItem

log = logging.getLogger(__name__)


class AddReminder:
    """Glues api stage together, acts as entry-point for HTTP requests"""
    def __init__(self, buffer: EventBuffer, tvm_tickets: TvmServiceTickets):
        self._buffer = buffer
        self._tvm_tickets = tvm_tickets

    async def __call__(self, request: web.Request):
        data = await request.json(loads=jsend.loads)
        context = data.get('context', {})
        check_context(context)

        owner_client_id = None
        tvm_service_ticket = request.headers.getone('X-Ya-Service-Ticket', None)
        if tvm_service_ticket and self._tvm_tickets:
            ticket_info = await self._tvm_tickets.parse(tvm_service_ticket)
            owner_client_id = ticket_info.src

        return await self._buffer.add(NotifyItem(
            bucket_id=data.get('bucket_id'),
            run_at=parse_datetime(data['run_at'], 'run_at'),
            cb_url=validated_url(data.get('cb_url'), 'cb_url'),
            group_key=request.match_info['group_key'],
            event_key=request.match_info['event_key'],
            owner_client_id=owner_client_id,
            context=jsend.dumps(context),
        ))
