import datetime

from dataclasses import dataclass, field


@dataclass
class NotifyItem:
    """Input info about notification to be planned"""
    run_at: datetime.datetime
    originally_run_at: datetime.datetime = field(init=False)
    bucket_id: int = None
    event_key: str = None
    group_key: str = None
    owner_client_id: int = None
    cb_url: str = None
    context: str = None

    def __post_init__(self):
        self.originally_run_at = self.run_at
